/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.util.CoverageStoreUtils;

public final class CoverageStoresNewForm
extends ActionForm {
    private static final long serialVersionUID = -7723738069176272163L;
    private String selectedDescription;
    private String dataFormatID;
    private List formatDescriptions;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.selectedDescription = "";
        this.dataFormatID = "";
        this.formatDescriptions = CoverageStoreUtils.listDataFormatsDescriptions();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (!this.getDataFormatDescriptions().contains(this.getSelectedDescription())) {
            errors.add("selectedDescription", new ActionError("error.dataFormatFactory.invalid", (Object)this.getSelectedDescription()));
        }
        if (this.getDataFormatID() == null || "".equals(this.getDataFormatID())) {
            errors.add("dataFormatID", new ActionError("error.dataFormatId.required", (Object)this.getDataFormatID()));
        } else if (!Pattern.matches("^[a-zA-Z](\\w|\\.)*$", this.getDataFormatID())) {
            errors.add("dataFormatID", new ActionError("error.dataFormatId.invalid", (Object)this.getDataFormatID()));
        }
        return errors;
    }

    public String getDataFormatID() {
        return this.dataFormatID;
    }

    public String getSelectedDescription() {
        return this.selectedDescription;
    }

    public void setDataFormatID(String string) {
        this.dataFormatID = string;
    }

    public void setSelectedDescription(String string) {
        this.selectedDescription = string;
    }

    public SortedSet getDataFormatDescriptions() {
        return new TreeSet(this.formatDescriptions);
    }
}

