/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.upload.FormFile;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.form.data.FormUtils;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.CoverageStoreUtils;
import org.vfny.geoserver.util.CoverageUtils;
import org.vfny.geoserver.util.Requests;

public final class CoverageStoresEditorForm
extends ActionForm {
    private static final long serialVersionUID = 8469919940722502675L;
    private ArrayList paramHelp;
    private String dataFormatId;
    private boolean enabled;
    private String namespaceId;
    private String type;
    private String url;
    private FormFile urlFile = null;
    private String description;
    private List paramKeys;
    private List paramValues;
    private SortedSet namespaces;
    private boolean enabledChecked = false;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.enabledChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = (DataConfig)context.getAttribute("Config.Data");
        this.namespaces = new TreeSet(config.getNameSpaces().keySet());
        CoverageStoreConfig dfConfig = Requests.getUserContainer((HttpServletRequest)request).getDataFormatConfig();
        if (dfConfig == null) {
            throw new RuntimeException("selectedDataFormatId required in Session");
        }
        this.dataFormatId = dfConfig.getId();
        this.description = dfConfig.getAbstract();
        this.enabled = dfConfig.isEnabled();
        this.namespaceId = dfConfig.getNameSpaceId();
        if ("".equals(this.namespaceId) && config.getDefaultNameSpace() != null) {
            this.namespaceId = config.getDefaultNameSpace().getPrefix();
        }
        this.url = dfConfig.getUrl();
        Format factory = dfConfig.getFactory();
        this.type = dfConfig.getType() != null && dfConfig.getType().length() > 0 ? dfConfig.getType() : factory.getName();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        CoverageStoreConfig dfConfig = user.getDataFormatConfig();
        Format factory = dfConfig.getFactory();
        ParameterValueGroup info = factory.getReadParameters();
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        if (this.paramKeys != null) {
            int length = this.paramKeys.size();
            String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            for (int i = 0; i < length; ++i) {
                String key = this.getParamKey(i);
                if (key.equalsIgnoreCase(readGeometryKey)) continue;
                ParameterValue param = CoverageStoreUtils.find((ParameterValueGroup)info, (String)key);
                if (param == null) {
                    errors.add("paramValue[" + i + "]", new ActionError("error.dataFormatEditor.param.missing", (Object)key, (Object)factory.getDescription()));
                    continue;
                }
                Boolean maxSize = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxSize != null && maxSize.booleanValue()) {
                    String size = null;
                    ControllerConfig cc = mapping.getModuleConfig().getControllerConfig();
                    size = cc == null ? Long.toString(0xFA00000L) : cc.getMaxFileSize();
                    errors.add("styleID", new ActionError("error.file.maxLengthExceeded", (Object)size));
                    return errors;
                }
                Object value = CoverageUtils.getCvParamValue((String)key, (ParameterValue)param, (List)this.paramValues, (int)i);
                if (value == null) continue;
                connectionParams.put(key, value);
            }
        }
        if (factory instanceof AbstractGridFormat) {
            File file;
            AbstractGridFormat aFormat = (AbstractGridFormat)factory;
            if (-1 == factory.getClass().toString().indexOf("org.geotools.arcsde.gce.ArcSDERasterFormat")) {
                file = GeoserverDataDirectory.findDataFile((String)this.url);
                FormUtils.checkFileExistsAndCanRead((File)file, (ActionErrors)errors);
                if (!errors.isEmpty()) {
                    return errors;
                }
            } else {
                file = new File(this.url);
            }
            if (!aFormat.accepts((Object)file)) {
                String key = "error.coverage.invalidUrlForFormat";
                Object[] params = new Object[]{this.url, this.type};
                errors.add("URL", new ActionMessage(key, params));
                return errors;
            }
        }
        this.dump("form", connectionParams);
        return errors;
    }

    public void dump(String msg, Map params) {
        if (msg != null) {
            System.out.print(msg + " ");
        }
        System.out.print(" connection params { ");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            System.out.print(entry.getKey());
            System.out.print("=");
            if (entry.getValue() == null) {
                System.out.print("null");
            } else if (entry.getValue() instanceof String) {
                System.out.print("\"");
                System.out.print(entry.getValue());
                System.out.print("\"");
            } else {
                System.out.print(entry.getValue());
            }
            if (!i.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public Map getParams() {
        HashMap map = new HashMap();
        if (this.paramKeys != null) {
            int size = this.paramKeys.size();
            for (int i = 0; i < size; ++i) {
                map.put(this.paramKeys.get(i), this.paramValues.get(i));
            }
        }
        return map;
    }

    public List getParamKeys() {
        return this.paramKeys;
    }

    public String getParamKey(int index) {
        return (String)this.paramKeys.get(index);
    }

    public String getParamValue(int index) {
        return (String)this.paramValues.get(index);
    }

    public void setParamValues(int index, String value) {
        this.paramValues.set(index, value);
    }

    public String getDataFormatId() {
        return this.dataFormatId;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getParamValues() {
        return this.paramValues;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEnabled(boolean b) {
        this.setEnabledChecked(true);
        this.enabled = b;
    }

    public void setParamKeys(List list) {
        this.paramKeys = list;
    }

    public void setParamValues(List list) {
        this.paramValues = list;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }

    public String[] getParamHelp() {
        return this.paramHelp.toArray(new String[this.paramHelp.size()]);
    }

    public String getParamHelp(int index) {
        return (String)this.paramHelp.get(index);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FormFile getUrlFile() {
        return this.urlFile;
    }

    public void setUrlFile(FormFile filename) {
        this.urlFile = filename;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public SortedSet getNamespaces() {
        return this.namespaces;
    }
}

