/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.WMSConfig;
import org.vfny.geoserver.form.wms.WMSContentForm;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.UserContainer;

public final class WMSContentAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        WMSContentForm contentForm = (WMSContentForm)form;
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String SUBMIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.submit"));
        String GENERATE_BBOX = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String ADD_NEW_LAYERGROUP = "Add New Layer-Group";
        String REMOVE_LAYERGROUP = "Remove";
        String action = contentForm.getAction();
        boolean enabled = contentForm.isEnabled();
        if (!contentForm.isEnabledChecked()) {
            enabled = false;
        }
        String onlineResource = contentForm.getOnlineResource();
        WMSConfig config = this.getWMSConfig();
        config.setEnabled(enabled);
        config.setOnlineResource(new URL(onlineResource));
        if (SUBMIT.equals(action)) {
            return this.executeSubmit(mapping, action, contentForm, config, request, response);
        }
        if ("Add New Layer-Group".equals(action)) {
            return this.executeAddNewLayerGroup(mapping, action, contentForm, config, request, response);
        }
        if (action.startsWith("Remove")) {
            return this.executeRemoveLayerGroup(mapping, action, contentForm, config, request, response);
        }
        if (action.startsWith(GENERATE_BBOX)) {
            return this.executeGenerateBBOX(mapping, action, contentForm, config, request, response);
        }
        return mapping.findForward("config.wms.content");
    }

    private ActionForward executeGenerateBBOX(ActionMapping mapping, String action, WMSContentForm contentForm, WMSConfig config, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        HashMap<String, GeneralEnvelope> envelopeMap = new HashMap<String, GeneralEnvelope>();
        int selectedLayerIndex = contentForm.getSelectedLayer();
        int bmi = 0;
        Iterator it = contentForm.getBaseMapTitles().iterator();
        while (it.hasNext()) {
            String baseMapTitle = (String)it.next();
            String baseMapLayers = (String)contentForm.getBaseMapLayers().get(bmi);
            String baseMapStyles = (String)contentForm.getBaseMapStyles().get(bmi);
            GeneralEnvelope envelope = (GeneralEnvelope)contentForm.getBaseMapEnvelopes().get(bmi);
            layerMap.put(baseMapTitle, baseMapLayers);
            styleMap.put(baseMapTitle, baseMapStyles);
            envelopeMap.put(baseMapTitle, envelope);
            if (selectedLayerIndex == bmi) {
                Data catalog = (Data)this.getServlet().getServletContext().getAttribute("DATA");
                GeneralEnvelope selectedEnvelope = null;
                String[] layerNames = baseMapLayers.split(",");
                for (int i = 0; i < layerNames.length; ++i) {
                    String layerName = layerNames[i].trim();
                    Integer layerType = catalog.getLayerType(layerName);
                    if (layerType == null) continue;
                    if (layerType == MapLayerInfo.TYPE_VECTOR) {
                        FeatureTypeInfo ftype = catalog.getFeatureTypeInfo(layerName);
                        FeatureTypeInfo featureTypeInfo = ftype = ftype != null ? ftype : catalog.getFeatureTypeInfo(layerName.substring(layerName.indexOf(":") + 1, layerName.length()));
                        if (selectedEnvelope == null) {
                            ReferencedEnvelope ftEnvelope = null;
                            try {
                                if (!(ftype.getBoundingBox() instanceof ReferencedEnvelope) || ftype.getBoundingBox().isNull()) {
                                    return mapping.findForward("config.wms.content");
                                }
                                ftEnvelope = (ReferencedEnvelope)ftype.getBoundingBox();
                            }
                            catch (IOException e) {
                                return mapping.findForward("config.wms.content");
                            }
                            selectedEnvelope = new GeneralEnvelope(new double[]{ftEnvelope.getMinX(), ftEnvelope.getMinY()}, new double[]{ftEnvelope.getMaxX(), ftEnvelope.getMaxY()});
                            selectedEnvelope.setCoordinateReferenceSystem(ftEnvelope.getCoordinateReferenceSystem());
                            continue;
                        }
                        CoordinateReferenceSystem dstCRS = selectedEnvelope.getCoordinateReferenceSystem();
                        ReferencedEnvelope ftEnvelope = null;
                        try {
                            if (!(ftype.getBoundingBox() instanceof ReferencedEnvelope)) {
                                return mapping.findForward("config.wms.content");
                            }
                            ftEnvelope = (ReferencedEnvelope)ftype.getBoundingBox();
                            ftEnvelope.transform(dstCRS, true);
                        }
                        catch (TransformException e) {
                            return mapping.findForward("config.wms.content");
                        }
                        catch (FactoryException e) {
                            return mapping.findForward("config.wms.content");
                        }
                        catch (IOException e) {
                            return mapping.findForward("config.wms.content");
                        }
                        ReferencedEnvelope newEnvelope = new ReferencedEnvelope(dstCRS);
                        newEnvelope.init(selectedEnvelope.getLowerCorner().getOrdinate(0), selectedEnvelope.getUpperCorner().getOrdinate(0), selectedEnvelope.getLowerCorner().getOrdinate(1), selectedEnvelope.getUpperCorner().getOrdinate(1));
                        newEnvelope.expandToInclude((Envelope)ftEnvelope);
                        selectedEnvelope = new GeneralEnvelope(new double[]{newEnvelope.getMinX(), newEnvelope.getMinY()}, new double[]{newEnvelope.getMaxX(), newEnvelope.getMaxY()});
                        selectedEnvelope.setCoordinateReferenceSystem(dstCRS);
                        continue;
                    }
                    if (layerType != MapLayerInfo.TYPE_RASTER) continue;
                    CoverageInfo cv = catalog.getCoverageInfo(layerName);
                    CoverageInfo coverageInfo = cv = cv != null ? cv : catalog.getCoverageInfo(layerName.substring(layerName.indexOf(":") + 1, layerName.length()));
                    if (selectedEnvelope == null) {
                        selectedEnvelope = cv.getEnvelope();
                        continue;
                    }
                    CoordinateReferenceSystem cvCRS = cv.getCrs();
                    CoordinateReferenceSystem dstCRS = selectedEnvelope.getCoordinateReferenceSystem();
                    ReferencedEnvelope cvEnvelope = new ReferencedEnvelope(cvCRS);
                    cvEnvelope.init(cv.getEnvelope().getLowerCorner().getOrdinate(0), cv.getEnvelope().getUpperCorner().getOrdinate(0), cv.getEnvelope().getLowerCorner().getOrdinate(1), cv.getEnvelope().getUpperCorner().getOrdinate(1));
                    try {
                        cvEnvelope.transform(dstCRS, true);
                    }
                    catch (TransformException e) {
                        return mapping.findForward("config.wms.content");
                    }
                    catch (FactoryException e) {
                        return mapping.findForward("config.wms.content");
                    }
                    ReferencedEnvelope newEnvelope = new ReferencedEnvelope(dstCRS);
                    newEnvelope.init(selectedEnvelope.getLowerCorner().getOrdinate(0), selectedEnvelope.getUpperCorner().getOrdinate(0), selectedEnvelope.getLowerCorner().getOrdinate(1), selectedEnvelope.getUpperCorner().getOrdinate(1));
                    newEnvelope.expandToInclude((Envelope)cvEnvelope);
                    selectedEnvelope = new GeneralEnvelope(new double[]{newEnvelope.getMinX(), newEnvelope.getMinY()}, new double[]{newEnvelope.getMaxX(), newEnvelope.getMaxY()});
                    selectedEnvelope.setCoordinateReferenceSystem(dstCRS);
                }
                if (selectedEnvelope != null) {
                    envelope.setCoordinateReferenceSystem(selectedEnvelope.getCoordinateReferenceSystem());
                    envelope.setEnvelope(selectedEnvelope);
                    envelopeMap.put(baseMapTitle, envelope);
                    contentForm.setBaseMapEnvelope(selectedLayerIndex, envelope);
                }
            }
            ++bmi;
        }
        if (selectedLayerIndex < 0) {
            return mapping.findForward("config.wms.content");
        }
        return mapping.findForward("config.wms.content");
    }

    private ActionForward executeRemoveLayerGroup(ActionMapping mapping, String action, WMSContentForm contentForm, WMSConfig config, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        HashMap<String, GeneralEnvelope> envelopeMap = new HashMap<String, GeneralEnvelope>();
        int removedLayerIndex = contentForm.getSelectedLayer();
        if (removedLayerIndex < 0) {
            return mapping.findForward("config.wms.content");
        }
        contentForm.getBaseMapTitles().remove(removedLayerIndex);
        contentForm.getBaseMapLayers().remove(removedLayerIndex);
        contentForm.getBaseMapStyles().remove(removedLayerIndex);
        contentForm.getBaseMapEnvelopes().remove(removedLayerIndex);
        contentForm.getMinCPs().remove(new Integer(removedLayerIndex));
        contentForm.getMaxCPs().remove(new Integer(removedLayerIndex));
        int bmi = 0;
        Iterator it = contentForm.getBaseMapTitles().iterator();
        while (it.hasNext()) {
            String baseMapTitle = (String)it.next();
            String baseMapLayers = (String)contentForm.getBaseMapLayers().get(bmi);
            String baseMapStyles = (String)contentForm.getBaseMapStyles().get(bmi);
            GeneralEnvelope envelope = (GeneralEnvelope)contentForm.getBaseMapEnvelopes().get(bmi);
            layerMap.put(baseMapTitle, baseMapLayers);
            styleMap.put(baseMapTitle, baseMapStyles);
            envelopeMap.put(baseMapTitle, envelope);
            ++bmi;
        }
        config.setBaseMapLayers(layerMap);
        config.setBaseMapStyles(styleMap);
        config.setBaseMapEnvelopes(envelopeMap);
        return mapping.findForward("config.wms.content");
    }

    private ActionForward executeAddNewLayerGroup(ActionMapping mapping, String action, WMSContentForm contentForm, WMSConfig config, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        HashMap<String, GeneralEnvelope> envelopeMap = new HashMap<String, GeneralEnvelope>();
        int bmi = 0;
        Iterator it = contentForm.getBaseMapTitles().iterator();
        while (it.hasNext()) {
            String baseMapTitle = (String)it.next();
            String baseMapLayers = (String)contentForm.getBaseMapLayers().get(bmi);
            String baseMapStyles = (String)contentForm.getBaseMapStyles().get(bmi);
            GeneralEnvelope envelope = (GeneralEnvelope)contentForm.getBaseMapEnvelopes().get(bmi);
            layerMap.put(baseMapTitle, baseMapLayers);
            styleMap.put(baseMapTitle, baseMapStyles);
            envelopeMap.put(baseMapTitle, envelope);
            ++bmi;
        }
        String name = "<new_layer_group>";
        int num = 2;
        while (config.getBaseMapLayers() != null && config.getBaseMapLayers().get(name) != null) {
            name = "<new_layer_group" + num + ">";
            ++num;
        }
        GeneralEnvelope defaultEnvelope = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        try {
            defaultEnvelope.setCoordinateReferenceSystem(CRS.decode((String)"EPSG:4326"));
        }
        catch (MismatchedDimensionException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new ServletException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new ServletException((Throwable)e);
        }
        layerMap.put(name, "");
        styleMap.put(name, "");
        envelopeMap.put(name, defaultEnvelope);
        contentForm.getBaseMapTitles().add(name);
        contentForm.getBaseMapLayers().add("");
        contentForm.getBaseMapStyles().add("");
        contentForm.getBaseMapEnvelopes().add(defaultEnvelope);
        config.setBaseMapLayers(layerMap);
        config.setBaseMapStyles(styleMap);
        config.setBaseMapEnvelopes(envelopeMap);
        return mapping.findForward("config.wms.content");
    }

    private ActionForward executeSubmit(ActionMapping mapping, String action, WMSContentForm contentForm, WMSConfig config, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> layerMap = new HashMap<String, String>();
        HashMap<String, String> styleMap = new HashMap<String, String>();
        HashMap<String, GeneralEnvelope> envelopeMap = new HashMap<String, GeneralEnvelope>();
        int bmi = 0;
        Iterator it = contentForm.getBaseMapTitles().iterator();
        while (it.hasNext()) {
            int i;
            String baseMapTitle = (String)it.next();
            String baseMapLayers = (String)contentForm.getBaseMapLayers().get(bmi);
            String baseMapStyles = (String)contentForm.getBaseMapStyles().get(bmi);
            GeneralEnvelope envelope = (GeneralEnvelope)contentForm.getBaseMapEnvelopes().get(bmi);
            Data catalog = (Data)this.getServlet().getServletContext().getAttribute("DATA");
            Object selectedEnvelope = null;
            String[] layerNames = baseMapLayers.split(",");
            String[] styles = baseMapStyles.split("\\s*,\\s*");
            for (i = 0; i < layerNames.length; ++i) {
                String layerName = layerNames[i].trim();
                Integer layerType = catalog.getLayerType(layerName);
                if (layerType != null) continue;
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("errors.invalid", (Object)new ActionMessage("Layer " + layerName)));
                this.saveErrors(request, errors);
                return mapping.findForward("config.wms.content");
            }
            for (i = 0; i < styles.length; ++i) {
                String styleName = styles[i].trim();
                Style style = catalog.getStyle(styleName);
                if (style != null || "".equals(styleName)) continue;
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.styleId.notFound", (Object)new ActionMessage(styleName)));
                this.saveErrors(request, errors);
                return mapping.findForward("config.wms.content");
            }
            layerMap.put(baseMapTitle, baseMapLayers);
            styleMap.put(baseMapTitle, baseMapStyles);
            envelopeMap.put(baseMapTitle, envelope);
            ++bmi;
        }
        config.setBaseMapLayers(layerMap);
        config.setBaseMapStyles(styleMap);
        config.setBaseMapEnvelopes(envelopeMap);
        this.getApplicationState().notifyConfigChanged();
        return mapping.findForward("config");
    }
}

