/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.grid.Format;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.CoverageConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.form.data.CoveragesEditorForm;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.UserContainer;

public final class CoveragesEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
            GeoServerAction.LOGGER.finer("form bean:" + form.getClass().getName());
        }
        CoveragesEditorForm coverageForm = (CoveragesEditorForm)form;
        String action = coverageForm.getAction();
        if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
            GeoServerAction.LOGGER.finer("CoveragesEditorAction is " + action);
        }
        String newCoverage = coverageForm.getNewCoverage();
        if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
            GeoServerAction.LOGGER.finer("CoveragesEditorNew is " + newCoverage);
        }
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String SUBMIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.submit"));
        String ENVELOPE = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String LOOKUP_SRS = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.lookupSRS.label"));
        if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
            GeoServerAction.LOGGER.finer("ENVELOPE: " + ENVELOPE);
        }
        if (SUBMIT.equals(action)) {
            return this.executeSubmit(mapping, coverageForm, user, request);
        }
        if (newCoverage != null && "true".equals(newCoverage)) {
            if (GeoServerAction.LOGGER.isLoggable(Level.FINER)) {
                GeoServerAction.LOGGER.finer("NEW COVERAGE: " + newCoverage);
            }
            request.setAttribute("newCoverage", (Object)"true");
        }
        if (ENVELOPE.equals(action)) {
            return this.executeEnvelope(mapping, coverageForm, user, request);
        }
        if (LOOKUP_SRS.equals(action)) {
            return this.executeLookupSRS(mapping, coverageForm, user, request);
        }
        try {
            this.sync(coverageForm, user.getCoverageConfig(), request);
        }
        catch (FactoryException e) {
            throw new ServletException((Throwable)e);
        }
        form.reset(mapping, request);
        return mapping.findForward("config.data.coverage.editor");
    }

    private ActionForward executeEnvelope(ActionMapping mapping, CoveragesEditorForm coverageForm, UserContainer user, HttpServletRequest request) throws IOException, ServletException {
        String formatID = coverageForm.getFormatId();
        Data catalog = this.getData();
        CoverageStoreInfo cvStoreInfo = catalog.getFormatInfo(formatID);
        if (cvStoreInfo == null) {
            cvStoreInfo = new CoverageStoreInfo(this.getDataConfig().getDataFormat(formatID).toDTO(), catalog);
        }
        Format format = cvStoreInfo.getFormat();
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cvStoreInfo.getReader();
        if (reader == null) {
            reader = (AbstractGridCoverage2DReader)((AbstractGridFormat)format).getReader((Object)GeoserverDataDirectory.findDataFile((String)cvStoreInfo.getUrl()));
        }
        try {
            GeneralEnvelope gEnvelope;
            GeneralEnvelope targetEnvelope;
            CoordinateReferenceSystem sourceCRS = reader.getCrs();
            GeneralEnvelope envelope = targetEnvelope = (gEnvelope = reader.getOriginalEnvelope());
            if (sourceCRS.getIdentifiers().isEmpty()) {
                String nativeCRS = coverageForm.getSrsName();
                if (nativeCRS != null) {
                    if (!nativeCRS.toUpperCase().startsWith("EPSG:")) {
                        try {
                            nativeCRS = "EPSG:" + Integer.decode(nativeCRS);
                            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)CRS.decode((String)nativeCRS), (boolean)true);
                            envelope = CRSUtilities.transform((MathTransform)transform, (Envelope)envelope);
                            coverageForm.setSrsName(nativeCRS);
                        }
                        catch (NumberFormatException e) {
                            coverageForm.setSrsName("UNKNOWN");
                        }
                    } else {
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)CRS.decode((String)nativeCRS), (boolean)true);
                        envelope = CRSUtilities.transform((MathTransform)transform, (Envelope)envelope);
                    }
                } else {
                    coverageForm.setSrsName("UNKNOWN");
                }
            } else {
                String identifier = sourceCRS.getIdentifiers().toArray()[0].toString();
                if (identifier != null && !identifier.startsWith("EPSG:")) {
                    identifier = "EPSG:" + identifier;
                }
                coverageForm.setSrsName(identifier);
            }
            coverageForm.setWKTString(sourceCRS.toWKT());
            coverageForm.setMinX(Double.toString(envelope.getLowerCorner().getOrdinate(0)));
            coverageForm.setMaxX(Double.toString(envelope.getUpperCorner().getOrdinate(0)));
            coverageForm.setMinY(Double.toString(envelope.getLowerCorner().getOrdinate(1)));
            coverageForm.setMaxY(Double.toString(envelope.getUpperCorner().getOrdinate(1)));
        }
        catch (FactoryRegistryException e) {
            throw new ServletException((Throwable)e);
        }
        catch (MismatchedDimensionException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new ServletException((Throwable)e);
        }
        catch (FactoryException e) {
            throw new ServletException((Throwable)e);
        }
        catch (TransformException e) {
            throw new ServletException((Throwable)e);
        }
        return mapping.findForward("config.data.coverage.editor");
    }

    private void sync(CoveragesEditorForm form, CoverageConfig config, HttpServletRequest request) throws FactoryException {
        config.setDefaultInterpolationMethod(form.getDefaultInterpolationMethod());
        config.setDescription(form.getDescription());
        config.setInterpolationMethods(this.interpolationMethods(form));
        config.setKeywords(this.keyWords(form));
        config.setLabel(form.getLabel());
        config.setMetadataLink(this.metadataLink(form));
        config.setNativeFormat(form.getNativeFormat());
        config.setRequestCRSs(this.requestCRSs(form));
        config.setResponseCRSs(this.responseCRSs(form));
        config.setCrs(CRS.parseWKT((String)form.getWKTString()));
        if (!form.getSrsName().toUpperCase().startsWith("EPSG")) {
            config.setSrsName("EPSG:" + form.getSrsName());
        } else {
            config.setSrsName(form.getSrsName());
        }
        config.setSrsWKT(form.getWKTString());
        if (!"UNKNOWN".equals(config.getSrsName()) && config.getSrsName() != null && config.getSrsName().toUpperCase().startsWith("EPSG:")) {
            config.setCrs(CRS.decode((String)config.getSrsName()));
        }
        config.setEnvelope(this.getEnvelope(form, config.getCrs()));
        config.setSupportedFormats(this.supportedFormats(form));
        config.setDefaultStyle(form.getStyleId());
        if (form.getOtherSelectedStyles() != null) {
            config.getStyles().clear();
            for (int i = 0; i < form.getOtherSelectedStyles().length; ++i) {
                config.addStyle(form.getOtherSelectedStyles()[i]);
            }
        }
        config.setName(form.getName());
        config.setWmsPath(form.getWmsPath());
        StringBuffer temp = new StringBuffer(config.getFormatId());
        temp.append("_").append(form.getName());
        config.setDirName(temp.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator it = form.getParamKeys().iterator();
        int index = 0;
        while (it.hasNext()) {
            String paramKey = (String)it.next();
            String paramValue = (String)form.getParamValues().get(index);
            params.put(paramKey, paramValue);
            ++index;
        }
        config.setParameters(params);
    }

    private ActionForward executeSubmit(ActionMapping mapping, CoveragesEditorForm form, UserContainer user, HttpServletRequest request) throws IOException {
        CoverageConfig config = user.getCoverageConfig();
        try {
            this.sync(form, config, request);
        }
        catch (FactoryException e) {
            IOException ex = new IOException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        DataConfig dataConfig = this.getDataConfig();
        StringBuffer coverage = new StringBuffer(config.getFormatId());
        dataConfig.addCoverage(coverage.append(":").append(config.getName()).toString(), config);
        this.getApplicationState().notifyConfigChanged();
        user.setCoverageConfig(null);
        return mapping.findForward("config.data.coverage");
    }

    private GeneralEnvelope getEnvelope(CoveragesEditorForm coverageForm, CoordinateReferenceSystem crs) {
        double[] coordinates = new double[4];
        CoordinateSystem cs = crs.getCoordinateSystem();
        boolean lonFirst = true;
        if (AxisDirection.NORTH.equals(cs.getAxis(0).getDirection().absolute())) {
            lonFirst = false;
        }
        boolean swapXY = !lonFirst;
        int latIndex = lonFirst ? 1 : 0;
        AxisDirection latitude = cs.getAxis(latIndex).getDirection();
        AxisDirection longitude = cs.getAxis((latIndex + 1) % 2).getDirection();
        boolean[] blArray = new boolean[2];
        boolean bl = lonFirst ? !longitude.equals(AxisDirection.EAST) : (blArray[0] = !latitude.equals(AxisDirection.NORTH));
        blArray[1] = lonFirst ? !latitude.equals(AxisDirection.NORTH) : !longitude.equals(AxisDirection.EAST);
        boolean[] reverse = blArray;
        double d = !reverse[(latIndex + 1) % 2] ? (!swapXY ? Double.parseDouble(coverageForm.getMinX()) : Double.parseDouble(coverageForm.getMinY())) : (coordinates[0] = !swapXY ? Double.parseDouble(coverageForm.getMaxX()) : Double.parseDouble(coverageForm.getMaxY()));
        double d2 = !reverse[latIndex] ? (!swapXY ? Double.parseDouble(coverageForm.getMinY()) : Double.parseDouble(coverageForm.getMinX())) : (coordinates[1] = !swapXY ? Double.parseDouble(coverageForm.getMaxY()) : Double.parseDouble(coverageForm.getMaxX()));
        double d3 = !reverse[(latIndex + 1) % 2] ? (!swapXY ? Double.parseDouble(coverageForm.getMaxX()) : Double.parseDouble(coverageForm.getMaxY())) : (coordinates[2] = !swapXY ? Double.parseDouble(coverageForm.getMinX()) : Double.parseDouble(coverageForm.getMinY()));
        coordinates[3] = !reverse[latIndex] ? (!swapXY ? Double.parseDouble(coverageForm.getMaxY()) : Double.parseDouble(coverageForm.getMaxX())) : (!swapXY ? Double.parseDouble(coverageForm.getMinY()) : Double.parseDouble(coverageForm.getMinX()));
        GeneralEnvelope envelope = new GeneralEnvelope(new double[]{coordinates[0], coordinates[1]}, new double[]{coordinates[2], coordinates[3]});
        envelope.setCoordinateReferenceSystem(crs);
        return envelope;
    }

    private ActionForward executeLookupSRS(ActionMapping mapping, CoveragesEditorForm coverageForm, UserContainer user, HttpServletRequest request) throws IOException, ServletException {
        String formatID = coverageForm.getFormatId();
        Data catalog = this.getData();
        CoverageStoreInfo cvStoreInfo = catalog.getFormatInfo(formatID);
        if (cvStoreInfo == null) {
            cvStoreInfo = new CoverageStoreInfo(this.getDataConfig().getDataFormat(formatID).toDTO(), catalog);
        }
        Format format = cvStoreInfo.getFormat();
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cvStoreInfo.getReader();
        if (reader == null) {
            reader = (AbstractGridCoverage2DReader)((AbstractGridFormat)format).getReader((Object)GeoserverDataDirectory.findDataFile((String)cvStoreInfo.getUrl()));
        }
        try {
            GeneralEnvelope gEnvelope;
            GeneralEnvelope targetEnvelope;
            CoordinateReferenceSystem sourceCRS = reader.getCrs();
            GeneralEnvelope envelope = targetEnvelope = (gEnvelope = reader.getOriginalEnvelope());
            String s = CRS.lookupIdentifier((CoordinateReferenceSystem)sourceCRS, Collections.singleton("EPSG"), (boolean)true);
            if (s == null) {
                coverageForm.setSrsName("UNKNOWN");
            } else if (s.toUpperCase().startsWith("EPSG:")) {
                coverageForm.setSrsName(s);
            } else {
                coverageForm.setSrsName("EPSG:" + s);
            }
        }
        catch (Exception e) {
            coverageForm.setSrsName("UNKNOWN");
        }
        return mapping.findForward("config.data.coverage.editor");
    }

    private MetaDataLink metadataLink(CoveragesEditorForm coverageForm) {
        MetaDataLink ml = new MetaDataLink();
        if (coverageForm.getMetadataLink() != null && coverageForm.getMetadataLink().length() > 0) {
            ml.setAbout(coverageForm.getMetadataLink());
            ml.setMetadataType("other");
        } else {
            ml = null;
        }
        return ml;
    }

    private List keyWords(CoveragesEditorForm coverageForm) {
        LinkedList<String> keywords = new LinkedList<String>();
        String[] array = coverageForm.getKeywords() != null ? coverageForm.getKeywords().split(" ") : new String[]{};
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            keywords.add(array[i]);
        }
        return keywords;
    }

    private List interpolationMethods(CoveragesEditorForm coverageForm) {
        LinkedList<String> interpolationMethods = new LinkedList<String>();
        String[] array = coverageForm.getInterpolationMethods() != null ? coverageForm.getInterpolationMethods().split(",") : new String[]{};
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            interpolationMethods.add(array[i]);
        }
        return interpolationMethods;
    }

    private List requestCRSs(CoveragesEditorForm coverageForm) {
        LinkedList<String> requestCRSs = new LinkedList<String>();
        String[] array = coverageForm.getRequestCRSs() != null ? coverageForm.getRequestCRSs().split(",") : new String[]{};
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            requestCRSs.add(array[i]);
        }
        return requestCRSs;
    }

    private List responseCRSs(CoveragesEditorForm coverageForm) {
        LinkedList<String> responseCRSs = new LinkedList<String>();
        String[] array = coverageForm.getResponseCRSs() != null ? coverageForm.getResponseCRSs().split(",") : new String[]{};
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            responseCRSs.add(array[i]);
        }
        return responseCRSs;
    }

    private List supportedFormats(CoveragesEditorForm coverageForm) {
        LinkedList<String> supportedFormats = new LinkedList<String>();
        String[] array = coverageForm.getSupportedFormats() != null ? coverageForm.getSupportedFormats().split(",") : new String[]{};
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            supportedFormats.add(array[i]);
        }
        return supportedFormats;
    }
}

