/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.springframework.beans.factory.InitializingBean;
import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoValidator;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.xml.XMLConfigWriter;

public class ApplicationState
implements PlugIn,
InitializingBean {
    public static final String WEB_CONTAINER_KEY = "GeoServer.ApplicationState";
    private Date configTimestamp;
    private Date appTimestamp;
    private Date xmlTimestamp;
    private int[] geoserverStatus = new int[13];
    private Map geoserverNSErrors;
    private Map geoserverDSErrors;
    private Map geoserverVPErrors;
    Data data;
    GeoValidator validator;
    Config config;

    public ApplicationState() {
        this(null, null, null);
    }

    public ApplicationState(Data data, GeoValidator validator, Config config) {
        this.data = data;
        this.validator = validator;
        this.config = config;
    }

    public void destroy() {
    }

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.appTimestamp = this.configTimestamp = this.getXmlTimestamp();
        this.geoserverStatus[0] = -1;
    }

    public boolean isConfigChanged() {
        return this.configTimestamp != null && (this.appTimestamp == null || this.configTimestamp.after(this.appTimestamp));
    }

    private boolean isValidationChanged() {
        return this.isConfigChanged();
    }

    public boolean isAppChanged() {
        return this.appTimestamp != null && this.appTimestamp.after(this.getXmlTimestamp());
    }

    public void notifyLoadXML() {
        this.appTimestamp = this.xmlTimestamp;
        this.configTimestamp = this.xmlTimestamp;
    }

    public void notifyToGeoServer() {
        this.appTimestamp = new Date();
    }

    public void notifiySaveXML() {
        this.xmlTimestamp = new Date();
    }

    public void notifyConfigChanged() {
        this.configTimestamp = new Date();
    }

    public int getWcsGood() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[4];
    }

    public int getWcsBad() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[5];
    }

    public int getWcsDisabled() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[6];
    }

    public int getWfsGood() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[1];
    }

    public int getWfsBad() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[2];
    }

    public int getWfsDisabled() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[3];
    }

    public int getWmsGood() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[4];
    }

    public int getWmsBad() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[5];
    }

    public int getWmsDisabled() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[6];
    }

    public int getDataGood() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[7];
    }

    public int getDataBad() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[8];
    }

    public int getDataDisabled() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverStatus[9];
    }

    public int getGeoserverGood() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return (int)((double)(this.geoserverStatus[1] + this.geoserverStatus[4] + this.geoserverStatus[7]) / 3.0);
    }

    public int getGeoserverBad() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return (int)((double)(this.geoserverStatus[2] + this.geoserverStatus[5] + this.geoserverStatus[8]) / 3.0);
    }

    public int getGeoserverDisabled() {
        if (this.geoserverStatus[0] != (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return (int)((double)(this.geoserverStatus[3] + this.geoserverStatus[6] + this.geoserverStatus[9]) / 3.0);
    }

    private void loadStatus() {
        Object o;
        Object key;
        this.geoserverStatus[0] = (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0);
        this.geoserverNSErrors = this.data.statusNamespaces();
        this.geoserverDSErrors = this.data.statusDataStores();
        Map tmpVP = this.validator.getErrors();
        int g = 0;
        int b = 0;
        int d = 0;
        Iterator<Object> i = null;
        i = this.geoserverNSErrors.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            o = this.geoserverNSErrors.get(key);
            if (Boolean.TRUE.equals(o)) {
                ++g;
                i.remove();
                continue;
            }
            if (Boolean.FALSE.equals(o)) {
                ++d;
                i.remove();
                continue;
            }
            ++b;
        }
        if (g + b + d == 0) {
            this.geoserverStatus[7] = 100;
            this.geoserverStatus[8] = 0;
            this.geoserverStatus[9] = 0;
        } else {
            this.geoserverStatus[7] = (int)(100.0 * (double)g / (double)(g + b + d));
            this.geoserverStatus[8] = (int)(100.0 * (double)b / (double)(g + b + d));
            this.geoserverStatus[9] = (int)(100.0 * (double)d / (double)(g + b + d));
        }
        i = this.geoserverDSErrors.keySet().iterator();
        g = 0;
        b = 0;
        d = 0;
        while (i.hasNext()) {
            key = i.next();
            o = this.geoserverDSErrors.get(key);
            if (Boolean.TRUE.equals(o)) {
                ++g;
                i.remove();
                continue;
            }
            if (Boolean.FALSE.equals(o)) {
                ++d;
                i.remove();
                continue;
            }
            ++b;
        }
        if (g + b + d == 0) {
            this.geoserverStatus[4] = 100;
            this.geoserverStatus[1] = 100;
            this.geoserverStatus[5] = 0;
            this.geoserverStatus[2] = 0;
            this.geoserverStatus[6] = 0;
            this.geoserverStatus[3] = 0;
        } else {
            this.geoserverStatus[1] = this.geoserverStatus[4] = (int)(100.0 * (double)g / (double)(g + b + d));
            this.geoserverStatus[2] = this.geoserverStatus[5] = (int)(100.0 * (double)b / (double)(g + b + d));
            this.geoserverStatus[3] = this.geoserverStatus[6] = (int)(100.0 * (double)d / (double)(g + b + d));
        }
        g = 0;
        b = 0;
        d = 0;
        if (tmpVP != null) {
            i = tmpVP.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                o = tmpVP.get(key);
                if (Boolean.TRUE.equals(o)) {
                    ++g;
                    i.remove();
                    continue;
                }
                if (Boolean.FALSE.equals(o)) {
                    ++d;
                    i.remove();
                    continue;
                }
                ++b;
            }
        }
        if (g + b + d == 0) {
            this.geoserverStatus[10] = 100;
            this.geoserverStatus[11] = 0;
            this.geoserverStatus[12] = 0;
        } else {
            this.geoserverStatus[10] = (int)(100.0 * (double)g / (double)(g + b + d));
            this.geoserverStatus[11] = (int)(100.0 * (double)b / (double)(g + b + d));
            this.geoserverStatus[12] = (int)(100.0 * (double)d / (double)(g + b + d));
        }
        this.geoserverVPErrors = new HashMap();
        if (tmpVP != null) {
            i = tmpVP.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Object dto = e.getKey();
                if (dto instanceof PlugInDTO) {
                    this.geoserverVPErrors.put("PlugIn:" + ((PlugInDTO)dto).getName(), e.getValue());
                    continue;
                }
                if (dto instanceof TestDTO) {
                    this.geoserverVPErrors.put("Test:" + ((TestDTO)dto).getName(), e.getValue());
                    continue;
                }
                if (!(dto instanceof TestSuiteDTO)) continue;
                this.geoserverVPErrors.put("TestSuite:" + ((TestSuiteDTO)dto).getName(), e.getValue());
            }
        }
    }

    public Exception getDataStoreError(String key) {
        return (Exception)this.getDataStoreErrors().get(key);
    }

    public Exception getNameSpaceError(String key) {
        return (Exception)this.getNameSpaceErrors().get(key);
    }

    public Exception getWFSError(String key) {
        return (Exception)this.getNameSpaceErrors().get(key);
    }

    public Exception getWMSError(String key) {
        return (Exception)this.getNameSpaceErrors().get(key);
    }

    public Exception getValidationError(String key) {
        return (Exception)this.getValidationErrors().get(key);
    }

    public Map getNameSpaceErrors() {
        if (this.geoserverNSErrors == null || this.geoserverStatus[0] == (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverNSErrors;
    }

    public List getNameSpaceErrorKeys() {
        return new LinkedList(this.getNameSpaceErrors().keySet());
    }

    public List getNameSpaceErrorValues() {
        return new LinkedList(this.getNameSpaceErrors().values());
    }

    public Map getDataStoreErrors() {
        if (this.geoserverDSErrors == null || this.geoserverStatus[0] == (this.isConfigChanged() ? 1 : 0) + (this.isAppChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverDSErrors;
    }

    public List getDataStoreErrorKeys() {
        return new LinkedList(this.getDataStoreErrors().keySet());
    }

    public List getDataStoreErrorValues() {
        return new LinkedList(this.getDataStoreErrors().values());
    }

    public Map getValidationErrors() {
        if (this.geoserverNSErrors == null || this.geoserverStatus[0] == (this.isAppChanged() ? 1 : 0) + (this.isConfigChanged() ? 2 : 0) + (this.isValidationChanged() ? 4 : 0)) {
            this.loadStatus();
        }
        return this.geoserverVPErrors;
    }

    public List getValidationErrorKeys() {
        return new LinkedList(this.getValidationErrors().keySet());
    }

    public List getValidationErrorValues() {
        return new LinkedList(this.getValidationErrors().values());
    }

    public Map getWCSErrors() {
        return this.getNameSpaceErrors();
    }

    public List getWCSErrorKeys() {
        return this.getNameSpaceErrorKeys();
    }

    public Map getWFSErrors() {
        return this.getNameSpaceErrors();
    }

    public List getWFSErrorKeys() {
        return this.getNameSpaceErrorKeys();
    }

    public Map getWMSErrors() {
        return this.getNameSpaceErrors();
    }

    public List getWMSErrorKeys() {
        return this.getNameSpaceErrorKeys();
    }

    public Date getAppTimestamp() {
        return this.appTimestamp;
    }

    public Date getConfigTimestamp() {
        return this.configTimestamp;
    }

    public Date getXmlTimestamp() {
        if (this.xmlTimestamp == null) {
            File serviceFile;
            File dataDir = this.config.dataDirectory();
            boolean inDataDir = GeoserverDataDirectory.isTrueDataDir();
            File serviceDir = dataDir;
            try {
                serviceFile = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(serviceDir, "services.xml"), (boolean)false);
            }
            catch (ConfigurationException confE) {
                throw new RuntimeException(confE);
            }
            this.xmlTimestamp = new Date(serviceFile.lastModified());
        }
        return this.xmlTimestamp;
    }

    private void resetXMLTimestamp() {
        this.xmlTimestamp = null;
    }
}

