/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class DataFeatureTypesEditorForm
extends ActionForm {
    private String name;
    private String SRS;
    private String title;
    private String latLonBoundingBoxMinX;
    private String latLonBoundingBoxMinY;
    private String latLonBoundingBoxMaxX;
    private String latLonBoundingBoxMaxY;
    private String keywords;
    private String _abstract;
    private boolean _default;
    private boolean defaultChecked;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        FeatureTypeConfig ftConfig = (FeatureTypeConfig)request.getSession().getAttribute("selectedFeatureType");
        this._abstract = ftConfig.getAbstract();
        Envelope bounds = ftConfig.getLatLongBBox();
        if (bounds.isNull()) {
            this.latLonBoundingBoxMinX = "";
        } else {
            this.latLonBoundingBoxMinX = Double.toString(bounds.getMinX());
            this.latLonBoundingBoxMinY = Double.toString(bounds.getMinY());
            this.latLonBoundingBoxMaxX = Double.toString(bounds.getMaxX());
            this.latLonBoundingBoxMaxY = Double.toString(bounds.getMaxY());
        }
        this.name = ftConfig.getName();
        this.SRS = Integer.toString(ftConfig.getSRS());
        this.title = ftConfig.getTitle();
        this._default = ftConfig.getSchemaAttributes() == null || ftConfig.getSchemaAttributes().isEmpty();
        this.defaultChecked = false;
        StringBuffer buf = new StringBuffer();
        Iterator i = ftConfig.getKeywords().iterator();
        while (i.hasNext()) {
            String keyword = (String)i.next();
            buf.append(keyword);
            if (!i.hasNext()) continue;
            buf.append(" ");
        }
        this.keywords = buf.toString();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        DataConfig data = ConfigRequests.getDataConfig((HttpServletRequest)request);
        if ("".equals(this.latLonBoundingBoxMinX) || "".equals(this.latLonBoundingBoxMinY) || "".equals(this.latLonBoundingBoxMaxX) || "".equals(this.latLonBoundingBoxMaxY)) {
            errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.required"));
        } else {
            try {
                double minX = Double.parseDouble(this.latLonBoundingBoxMinX);
                double minY = Double.parseDouble(this.latLonBoundingBoxMinY);
                double maxX = Double.parseDouble(this.latLonBoundingBoxMaxX);
                double maxY = Double.parseDouble(this.latLonBoundingBoxMaxY);
            }
            catch (NumberFormatException badNumber) {
                errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.invalid", (Object)badNumber));
            }
        }
        return errors;
    }

    public String get_abstract() {
        return this._abstract;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLatLonBoundingBoxMinX() {
        return this.latLonBoundingBoxMinX;
    }

    public String getName() {
        return this.name;
    }

    public String getSRS() {
        return this.SRS;
    }

    public String getTitle() {
        return this.title;
    }

    public void set_abstract(String string) {
        this._abstract = string;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public void setLatLonBoundingBoxMinX(String text) {
        this.latLonBoundingBoxMinX = text;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSRS(String string) {
        this.SRS = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean is_default() {
        return this._default;
    }

    public void set_default(boolean _default) {
        this.defaultChecked = true;
        this._default = _default;
    }

    public boolean isDefaultChecked() {
        return this.defaultChecked;
    }

    public String getLatLonBoundingBoxMinY() {
        return this.latLonBoundingBoxMinY;
    }

    public void setLatLonBoundingBoxMinY(String latLonBoundingBox2) {
        this.latLonBoundingBoxMinY = latLonBoundingBox2;
    }

    public String getLatLonBoundingBoxMaxX() {
        return this.latLonBoundingBoxMaxX;
    }

    public void setLatLonBoundingBoxMaxX(String latLonBoundingBox3) {
        this.latLonBoundingBoxMaxX = latLonBoundingBox3;
    }

    public String getLatLonBoundingBoxMaxY() {
        return this.latLonBoundingBoxMaxY;
    }

    public void setLatLonBoundingBoxMaxY(String latLonBoundingBox4) {
        this.latLonBoundingBoxMaxY = latLonBoundingBox4;
    }
}

