/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataDataStoresNewForm
extends ActionForm {
    private static final Pattern idPattern = Pattern.compile("^\\a$");
    private String selectedDescription;
    private String dataStoreID;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.selectedDescription = "";
        this.dataStoreID = "";
    }

    public List getDescriptions() {
        List descriptions = DataStoreUtils.listDataStoresDescriptions();
        if (descriptions == null || descriptions.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return descriptions;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (!this.getDescriptions().contains(this.getSelectedDescription())) {
            errors.add("selectedDescription", new ActionError("error.dataStoreFactory.invalid", (Object)this.getSelectedDescription()));
        }
        if (this.getDataStoreID() == null || "".equals(this.getDataStoreID())) {
            errors.add("dataStoreID", new ActionError("error.dataStoreId.required", (Object)this.getDataStoreID()));
        } else if (!Pattern.matches("^[a-zA-Z](\\w|\\.)*$", this.getDataStoreID())) {
            errors.add("dataStoreID", new ActionError("error.dataStoreId.invalid", (Object)this.getDataStoreID()));
        }
        return errors;
    }

    public String getDataStoreID() {
        return this.dataStoreID;
    }

    public String getSelectedDescription() {
        return this.selectedDescription;
    }

    public void setDataStoreID(String string) {
        this.dataStoreID = string;
    }

    public void setSelectedDescription(String string) {
        this.selectedDescription = string;
    }

    public SortedSet getDataStoreDescriptions() {
        return new TreeSet(DataStoreUtils.listDataStoresDescriptions());
    }
}

