/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.wms;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.WMSConfig;

public class WMSContentForm
extends ActionForm {
    private boolean enabled;
    private String onlineResource;
    private String baseMapLayers;
    private String baseMapStyles;
    private String baseMapTitle;
    private boolean enabledChecked = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setBaseMapTitle(String title) {
        this.baseMapTitle = title;
    }

    public String getBaseMapTitle() {
        return this.baseMapTitle;
    }

    public String getBaseMapLayers() {
        return this.baseMapLayers;
    }

    public void setBaseMapLayers(String layers) {
        this.baseMapLayers = layers;
    }

    public String getBaseMapStyles() {
        return this.baseMapStyles;
    }

    public void setBaseMapStyles(String styles) {
        this.baseMapStyles = styles;
    }

    public void setEnabled(boolean b) {
        this.enabledChecked = true;
        this.enabled = b;
    }

    public void setOnlineResource(String string) {
        this.onlineResource = string;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        this.enabledChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        WMSConfig config = (WMSConfig)context.getAttribute("Config.WMS");
        this.enabled = config.isEnabled();
        URL url = config.getOnlineResource();
        this.onlineResource = url != null ? url.toString() : "";
        if (config.getBaseMapLayers() != null) {
            String[] baseMapTitleArray = config.getBaseMapLayers().keySet().toArray(new String[0]);
            String[] baseMapLayersArray = config.getBaseMapLayers().values().toArray(new String[0]);
            String[] baseMapStylesArray = config.getBaseMapStyles().values().toArray(new String[0]);
            this.baseMapTitle = baseMapTitleArray.length > 0 ? baseMapTitleArray[0] : "";
            this.baseMapLayers = baseMapLayersArray.length > 0 ? baseMapLayersArray[0] : "";
            this.baseMapStyles = baseMapStylesArray.length > 0 ? baseMapStylesArray[0] : "";
        }
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.onlineResource == null || "".equals(this.onlineResource)) {
            errors.add("onlineResource", new ActionError("error.wms.onlineResource.required", (Object)this.onlineResource));
        } else {
            try {
                URL url = new URL(this.onlineResource);
            }
            catch (MalformedURLException badURL) {
                errors.add("onlineResource", new ActionError("error.wms.onlineResource.malformed", (Object)badURL));
            }
        }
        return errors;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }
}

