/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.global;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.ContactConfig;
import org.vfny.geoserver.config.GlobalConfig;

public class GeoServerConfigurationForm
extends ActionForm {
    private int maxFeatures;
    private boolean verbose;
    private int numDecimals;
    private String charset;
    private String proxyBaseUrl;
    private String schemaBaseURL;
    private String loggingLevel;
    private String adminUserName;
    private String adminPassword;
    private boolean verboseExceptions;
    private String contactPerson;
    private String contactOrganization;
    private String contactPosition;
    private String addressType;
    private String address;
    private String addressCity;
    private String addressState;
    private String addressPostalCode;
    private String addressCountry;
    private String contactVoice;
    private String contactFacsimile;
    private String contactEmail;
    private boolean verboseChecked;
    private boolean verboseExceptionsChecked;
    private boolean loggingToFile;
    private boolean loggingToFileChecked;
    private String logLocation;
    private double jaiMemoryCapacity;
    private double jaiMemoryThreshold;
    private int jaiTileThreads;
    private int jaiTilePriority;
    private boolean jaiRecycling;
    private boolean jaiRecyclingChecked;
    private boolean imageIOCache;
    private boolean imageIOCacheChecked;
    private boolean jaiJPEGNative;
    private boolean jaiJPEGNativeChecked;
    private boolean jaiPNGNative;
    private boolean jaiPNGNativeChecked;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        super.reset(arg0, request);
        GlobalConfig globalConfig = (GlobalConfig)this.getServlet().getServletContext().getAttribute("Config.Global");
        this.maxFeatures = globalConfig.getMaxFeatures();
        this.verbose = globalConfig.isVerbose();
        this.verboseExceptions = globalConfig.isVerboseExceptions();
        this.verboseChecked = false;
        this.verboseExceptionsChecked = false;
        this.numDecimals = globalConfig.getNumDecimals();
        this.charset = globalConfig.getCharSet().name();
        this.proxyBaseUrl = globalConfig.getProxyBaseUrl();
        this.schemaBaseURL = globalConfig.getSchemaBaseUrl();
        this.adminUserName = globalConfig.getAdminUserName();
        this.adminPassword = globalConfig.getAdminPassword();
        this.loggingLevel = globalConfig.getLoggingLevel() == null ? Level.OFF.getName() : globalConfig.getLoggingLevel().getName();
        this.loggingToFile = globalConfig.getLoggingToFile();
        this.loggingToFileChecked = false;
        this.logLocation = globalConfig.getLogLocation();
        this.jaiMemoryCapacity = globalConfig.getJaiMemoryCapacity();
        this.jaiMemoryThreshold = globalConfig.getJaiMemoryThreshold();
        this.jaiTileThreads = globalConfig.getJaiTileThreads();
        this.jaiTilePriority = globalConfig.getJaiTilePriority();
        this.jaiRecycling = globalConfig.isJaiRecycling();
        this.jaiRecyclingChecked = false;
        this.imageIOCache = globalConfig.isImageIOCache();
        this.imageIOCacheChecked = false;
        this.jaiJPEGNative = globalConfig.isJaiJPEGNative();
        this.jaiJPEGNativeChecked = false;
        this.jaiPNGNative = globalConfig.isJaiPNGNative();
        this.jaiPNGNativeChecked = false;
        ContactConfig contactConfig = globalConfig.getContact();
        this.contactPerson = contactConfig.getContactPerson();
        this.contactOrganization = contactConfig.getContactOrganization();
        this.contactPosition = contactConfig.getContactPosition();
        this.addressType = contactConfig.getAddressType();
        this.address = contactConfig.getAddress();
        this.addressCity = contactConfig.getAddressCity();
        this.addressCountry = contactConfig.getAddressCountry();
        this.addressPostalCode = contactConfig.getAddressPostalCode();
        this.addressState = contactConfig.getAddressState();
        this.contactVoice = contactConfig.getContactVoice();
        this.contactFacsimile = contactConfig.getContactFacsimile();
        this.contactEmail = contactConfig.getContactEmail();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        long maxMemoryAvailable = Runtime.getRuntime().maxMemory() - 0x400000L;
        if (this.jaiMemoryCapacity < 0.0 || this.jaiMemoryCapacity > 2.097152E8) {
            errors.add("jaiMemCapacity", new ActionError("error.geoserver.JAIMemCapacity", (Object)new Long(0xC800000L)));
        }
        if (this.jaiMemoryThreshold < 0.0 || this.jaiMemoryThreshold > 1.0) {
            errors.add("jaiMemThreshold", new ActionError("error.geoserver.JAIMemThreshold"));
        }
        if (this.jaiTileThreads < 0 || this.jaiTileThreads > 100) {
            errors.add("jaiTileThreads", new ActionError("error.geoserver.JAITileThreads"));
        }
        if (this.jaiTilePriority < 1 || this.jaiTilePriority > 10) {
            errors.add("jaiTilePriority", new ActionError("error.geoserver.JAITilePriority"));
        }
        return errors;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verboseChecked = true;
        this.verbose = verbose;
    }

    public boolean isVerboseChecked() {
        return this.verboseChecked;
    }

    public void setVerboseChecked(boolean verboseChecked) {
        this.verboseChecked = verboseChecked;
    }

    public boolean isVerboseExceptionsChecked() {
        return this.verboseExceptionsChecked;
    }

    public void setVerboseExceptionsChecked(boolean verboseExceptionsChecked) {
        this.verboseExceptionsChecked = verboseExceptionsChecked;
    }

    public boolean isVerboseExceptions() {
        return this.verboseExceptions;
    }

    public void setVerboseExceptions(boolean verboseExceptions) {
        this.verboseExceptionsChecked = true;
        this.verboseExceptions = verboseExceptions;
    }

    public int getNumDecimals() {
        return this.numDecimals;
    }

    public void setNumDecimals(int numDecimals) {
        this.numDecimals = numDecimals;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getProxyBaseUrl() {
        return "".equals(this.proxyBaseUrl) ? null : this.proxyBaseUrl;
    }

    public void setProxyBaseUrl(String baseURL) {
        this.proxyBaseUrl = baseURL;
    }

    public String getSchemaBaseURL() {
        return this.schemaBaseURL;
    }

    public void setSchemaBaseURL(String schemaBaseURL) {
        this.schemaBaseURL = schemaBaseURL;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public String getAddressPostalCode() {
        return this.addressPostalCode;
    }

    public void setAddressPostalCode(String addressPostalCode) {
        this.addressPostalCode = addressPostalCode;
    }

    public String getAddressState() {
        return this.addressState;
    }

    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactFacsimile() {
        return this.contactFacsimile;
    }

    public void setContactFacsimile(String contactFacsimile) {
        this.contactFacsimile = contactFacsimile;
    }

    public String getContactOrganization() {
        return this.contactOrganization;
    }

    public void setContactOrganization(String contactOrganization) {
        this.contactOrganization = contactOrganization;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPosition() {
        return this.contactPosition;
    }

    public void setContactPosition(String contactPosition) {
        this.contactPosition = contactPosition;
    }

    public String getContactVoice() {
        return this.contactVoice;
    }

    public void setContactVoice(String contactVoice) {
        this.contactVoice = contactVoice;
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    public void setLoggingToFile(boolean loggingToFile) {
        this.loggingToFileChecked = true;
        this.loggingToFile = loggingToFile;
    }

    public boolean isLoggingToFile() {
        return this.loggingToFile;
    }

    public boolean isLoggingToFileChecked() {
        return this.loggingToFileChecked;
    }

    public void setLoggingToFileChecked(boolean loggingToFileChecked) {
        this.loggingToFileChecked = loggingToFileChecked;
    }

    public double getJaiMemoryCapacity() {
        return this.jaiMemoryCapacity;
    }

    public void setJaiMemoryCapacity(double jaiMemoryCapacity) {
        this.jaiMemoryCapacity = jaiMemoryCapacity;
    }

    public boolean getJaiRecycling() {
        return this.jaiRecycling;
    }

    public void setJaiRecycling(boolean jaiRecycling) {
        this.jaiRecyclingChecked = true;
        this.jaiRecycling = jaiRecycling;
    }

    public boolean getJaiJPEGNative() {
        return this.jaiJPEGNative;
    }

    public void setJaiJPEGNative(boolean jaiJPEGNative) {
        this.jaiJPEGNativeChecked = true;
        this.jaiJPEGNative = jaiJPEGNative;
    }

    public boolean getJaiPNGNative() {
        return this.jaiPNGNative;
    }

    public void setJaiPNGNative(boolean jaiPNGNative) {
        this.jaiPNGNativeChecked = true;
        this.jaiPNGNative = jaiPNGNative;
    }

    public boolean isJaiRecyclingChecked() {
        return this.jaiRecyclingChecked;
    }

    public boolean isJaiJPEGNativeChecked() {
        return this.jaiJPEGNativeChecked;
    }

    public boolean isJaiPNGNativeChecked() {
        return this.jaiPNGNativeChecked;
    }

    public void setJaiRecyclingChecked(boolean jaiRecyclingChecked) {
        this.jaiRecyclingChecked = jaiRecyclingChecked;
    }

    public void setJaiJPEGNativeChecked(boolean jaiJPEGNativeChecked) {
        this.jaiJPEGNativeChecked = jaiJPEGNativeChecked;
    }

    public void setJaiPNGNativeChecked(boolean jaiPNGNativeChecked) {
        this.jaiPNGNativeChecked = jaiPNGNativeChecked;
    }

    public boolean getImageIOCache() {
        return this.imageIOCache;
    }

    public void setImageIOCache(boolean imageIOCache) {
        this.imageIOCacheChecked = true;
        this.imageIOCache = imageIOCache;
    }

    public boolean isImageIOCacheChecked() {
        return this.imageIOCacheChecked;
    }

    public void setImageIOCacheChecked(boolean imageIOCacheChecked) {
        this.imageIOCacheChecked = imageIOCacheChecked;
    }

    public double getJaiMemoryThreshold() {
        return this.jaiMemoryThreshold;
    }

    public void setJaiMemoryThreshold(double jaiMemoryThreshold) {
        this.jaiMemoryThreshold = jaiMemoryThreshold;
    }

    public int getJaiTilePriority() {
        return this.jaiTilePriority;
    }

    public void setJaiTilePriority(int jaiTilePriority) {
        this.jaiTilePriority = jaiTilePriority;
    }

    public int getJaiTileThreads() {
        return this.jaiTileThreads;
    }

    public void setJaiTileThreads(int jaiTileThreads) {
        this.jaiTileThreads = jaiTileThreads;
    }
}

