/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.ConfigRequests;

public class DataDataStoresSelectForm
extends ActionForm {
    private String buttonAction;
    private String selectedDataStoreId;
    private List dataStoreIds;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.dataStoreIds = ConfigRequests.getDataConfig((HttpServletRequest)request).listDataStoreIds();
        this.selectedDataStoreId = null;
        this.buttonAction = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        Locale locale = request.getLocale();
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String EDIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String DELETE = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        if (this.getSelectedDataStoreId() == null) {
            return errors;
        }
        if (!this.getDataStoreIds().contains(this.getSelectedDataStoreId())) {
            errors.add("selectedDataStoreId", new ActionError("errors.factory.invalid", (Object)this.getSelectedDataStoreId()));
        }
        if (!DELETE.equals(this.getButtonAction()) && !EDIT.equals(this.getButtonAction())) {
            errors.add("buttonAction", new ActionError("errors.buttonAction.invalid", (Object)this.getButtonAction()));
        }
        return errors;
    }

    public List getDataStoreIds() {
        ArrayList ret = new ArrayList(this.dataStoreIds);
        Object[] sortable = ret.toArray();
        Arrays.sort(sortable);
        return Arrays.asList(sortable);
    }

    public String getSelectedDataStoreId() {
        return this.selectedDataStoreId;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String string) {
        this.buttonAction = string;
    }

    public void setSelectedDataStoreId(String string) {
        this.selectedDataStoreId = string;
    }
}

