/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.geotools.data.DataStoreFactorySpi;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.form.data.FormUtils;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.DataStoreUtils;
import org.vfny.geoserver.util.Requests;

public class DataDataStoresEditorForm
extends ActionForm {
    private ArrayList paramHelp;
    private String dataStoreId;
    private boolean enabled;
    private String namespaceId;
    private String description;
    private List paramKeys;
    private List paramValues;
    private List paramTypes;
    private List paramRequired;
    private SortedSet namespaces;
    private boolean enabledChecked = false;
    static /* synthetic */ Class class$0;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.enabledChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = (DataConfig)context.getAttribute("Config.Data");
        this.namespaces = new TreeSet(config.getNameSpaces().keySet());
        DataStoreConfig dsConfig = Requests.getUserContainer((HttpServletRequest)request).getDataStoreConfig();
        if (dsConfig == null) {
            throw new RuntimeException("selectedDataStoreId required in Session");
        }
        this.dataStoreId = dsConfig.getId();
        this.description = dsConfig.getAbstract();
        this.enabled = dsConfig.isEnabled();
        this.namespaceId = dsConfig.getNameSpaceId();
        if ("".equals(this.namespaceId)) {
            this.namespaceId = config.getDefaultNameSpace().getPrefix();
        }
        DataStoreFactorySpi factory = dsConfig.getFactory();
        DataStoreFactorySpi.Param[] params = factory.getParametersInfo();
        this.paramKeys = new ArrayList(params.length);
        this.paramValues = new ArrayList(params.length);
        this.paramTypes = new ArrayList(params.length);
        this.paramHelp = new ArrayList(params.length);
        this.paramRequired = new ArrayList(params.length);
        int i = 0;
        while (i < params.length) {
            DataStoreFactorySpi.Param param = params[i];
            String key = param.key;
            if (!"namespace".equals(key)) {
                Object value = dsConfig.getConnectionParams().get(key);
                String text = value == null ? null : (value instanceof String ? (String)value : param.text(value));
                this.paramKeys.add(key);
                this.paramValues.add(text != null ? text : "");
                this.paramTypes.add(param.type.getName());
                this.paramHelp.add(String.valueOf(param.description) + (param.required ? "" : " (optional)"));
                this.paramRequired.add(Boolean.valueOf(param.required).toString());
            }
            ++i;
        }
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        DataStoreConfig dsConfig = user.getDataStoreConfig();
        DataStoreFactorySpi factory = dsConfig.getFactory();
        DataStoreFactorySpi.Param[] info = factory.getParametersInfo();
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        int i = 0;
        while (i < this.paramKeys.size()) {
            block20: {
                String key = this.getParamKey(i);
                DataStoreFactorySpi.Param param = DataStoreUtils.find((DataStoreFactorySpi.Param[])info, (String)key);
                if (param == null) {
                    errors.add("paramValue[" + i + "]", new ActionError("error.dataStoreEditor.param.missing", (Object)key, (Object)factory.getDescription()));
                } else {
                    Object value;
                    block19: {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("java.net.URL");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.equals(param.type) && (value = this.getParamValue(i)) != null && !"".equals(value)) {
                            URL url = null;
                            try {
                                url = new URL((String)value);
                            }
                            catch (MalformedURLException e) {
                                try {
                                    if (GeoserverDataDirectory.findDataFile((String)value).exists()) {
                                        new URL("file://" + (String)value);
                                        this.setParamValues(i, "file://" + (String)value);
                                    }
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                            File file = GeoserverDataDirectory.findDataFile((String)value);
                            FormUtils.checkFileExistsAndCanRead((File)file, (ActionErrors)errors);
                            return errors;
                        }
                        try {
                            value = param.lookUp(this.getParams());
                            if (!(value instanceof String)) break block19;
                            value = param.parse((String)value);
                        }
                        catch (IOException erp) {
                            errors.add("paramValue[" + i + "]", new ActionError("error.dataStoreEditor.param.parse", (Object)key, (Object)param.type, (Object)erp));
                            break block20;
                        }
                        catch (Throwable t) {
                            errors.add("paramValue[" + i + "]", new ActionError("error.dataStoreEditor.param.parse", (Object)key, (Object)param.type, (Object)t));
                            break block20;
                        }
                    }
                    if (value == null && param.required) {
                        errors.add("paramValue[" + i + "]", new ActionError("error.dataStoreEditor.param.required", (Object)key));
                    } else if (value != null) {
                        connectionParams.put(key, value);
                    }
                }
            }
            ++i;
        }
        this.dump("form", connectionParams);
        if (!factory.canProcess(connectionParams)) {
            errors.add("paramValue", new ActionError("error.datastoreEditor.validation"));
        }
        return errors;
    }

    public void dump(String msg, Map params) {
        if (msg != null) {
            System.out.print(String.valueOf(msg) + " ");
        }
        System.out.print(" connection params { ");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            System.out.print(entry.getKey());
            System.out.print("=");
            if (entry.getValue() == null) {
                System.out.print("null");
            } else if (entry.getValue() instanceof String) {
                System.out.print("\"");
                System.out.print(entry.getValue());
                System.out.print("\"");
            } else {
                System.out.print(entry.getValue());
            }
            if (!i.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public Map getParams() {
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.paramKeys.size()) {
            map.put(this.paramKeys.get(i), this.paramValues.get(i));
            ++i;
        }
        return map;
    }

    public List getParamKeys() {
        return this.paramKeys;
    }

    public String getParamKey(int index) {
        return (String)this.paramKeys.get(index);
    }

    public String getParamValue(int index) {
        return (String)this.paramValues.get(index);
    }

    public void setParamValues(int index, String value) {
        this.paramValues.set(index, value);
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SortedSet getNamespaces() {
        return this.namespaces;
    }

    public List getParamValues() {
        return this.paramValues;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEnabled(boolean b) {
        this.setEnabledChecked(true);
        this.enabled = b;
    }

    public void setParamKeys(List list) {
        this.paramKeys = list;
    }

    public void setParamValues(List list) {
        this.paramValues = list;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String string) {
        this.namespaceId = string;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }

    public String[] getParamHelp() {
        return this.paramHelp.toArray(new String[this.paramHelp.size()]);
    }

    public String getParamHelp(int index) {
        return (String)this.paramHelp.get(index);
    }

    public List getParamTypes() {
        return this.paramTypes;
    }

    public String getParamType(int index) {
        return (String)this.paramTypes.get(index);
    }

    public List getParamRequired() {
        return this.paramRequired;
    }

    public String getParamRequired(int index) {
        return (String)this.paramRequired.get(index);
    }
}

