/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.ConfigRequests;

public final class CoverageStoresSelectForm
extends ActionForm {
    private static final long serialVersionUID = 950236665044594046L;
    private String buttonAction;
    private String selectedDataFormatId;
    private List dataFormatIds;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.dataFormatIds = ConfigRequests.getDataConfig((HttpServletRequest)request).listDataFormatIds();
        Object[] sortable = this.dataFormatIds.toArray();
        Arrays.sort(sortable);
        this.dataFormatIds = Arrays.asList(sortable);
        this.selectedDataFormatId = null;
        this.buttonAction = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        Locale locale = request.getLocale();
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String EDIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String DELETE = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        if (!this.getDataFormatIds().contains(this.getSelectedDataFormatId())) {
            errors.add("selectedDataFormatId", new ActionError("errors.factory.invalid", (Object)this.getSelectedDataFormatId()));
        }
        if (!DELETE.equals(this.getButtonAction()) && !EDIT.equals(this.getButtonAction())) {
            errors.add("buttonAction", new ActionError("errors.buttonAction.invalid", (Object)this.getButtonAction()));
        }
        return errors;
    }

    public List getDataFormatIds() {
        Object[] sortable = this.dataFormatIds.toArray();
        Arrays.sort(sortable);
        return Arrays.asList(sortable);
    }

    public String getSelectedDataFormatId() {
        return this.selectedDataFormatId;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String string) {
        this.buttonAction = string;
    }

    public void setSelectedDataFormatId(String string) {
        this.selectedDataFormatId = string;
    }
}

