/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.global;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.ContactConfig;
import org.vfny.geoserver.config.GlobalConfig;
import org.vfny.geoserver.form.global.GeoServerConfigurationForm;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;

public class GeoServerConfigurationSubmit
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) {
        String logLocation;
        Charset charset;
        GeoServerConfigurationForm form = (GeoServerConfigurationForm)incomingForm;
        int maxFeatures = form.getMaxFeatures();
        boolean verbose = form.isVerbose();
        if (!form.isVerboseChecked()) {
            verbose = false;
        }
        int numDecimals = form.getNumDecimals();
        String stringCharset = form.getCharset();
        try {
            charset = Charset.forName(stringCharset);
        }
        catch (IllegalArgumentException uce) {
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.badCharSet"));
            this.saveErrors(request, errors);
            return mapping.findForward("config.server");
        }
        String baseURL = form.getProxyBaseUrl();
        String schemaBaseURL = form.getSchemaBaseURL();
        String stringLevel = form.getLoggingLevel();
        Level loggingLevel = Level.parse(stringLevel);
        String adminUserName = form.getAdminUserName();
        String adminPassword = form.getAdminPassword();
        boolean verboseExceptions = form.isVerboseExceptions();
        if (!form.isVerboseExceptionsChecked()) {
            verboseExceptions = false;
        }
        boolean loggingToFile = form.isLoggingToFile();
        if (!form.isLoggingToFileChecked()) {
            loggingToFile = false;
        }
        if ((logLocation = form.getLogLocation()) != null && "".equals(logLocation.trim())) {
            logLocation = null;
        }
        if (logLocation != null) {
            File f = null;
            try {
                f = GeoServer.getLogLocation((String)logLocation);
            }
            catch (IOException e) {
                ActionErrors errors = new ActionErrors();
                ActionError error = new ActionError("error.couldNotCreateFile", (Object)f.getAbsolutePath(), (Object)e.getLocalizedMessage());
                errors.add("org.apache.struts.action.GLOBAL_ERROR", error);
                this.saveErrors(request, errors);
                return mapping.findForward("config.server");
            }
            if (!f.canWrite()) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.noWritePermission", (Object)logLocation));
                this.saveErrors(request, errors);
                return mapping.findForward("config.server");
            }
        }
        double jaiMemoryCapacity = form.getJaiMemoryCapacity();
        double jaiMemoryThreshold = form.getJaiMemoryThreshold();
        int jaiTileThreads = form.getJaiTileThreads();
        int jaiTilePriority = form.getJaiTilePriority();
        boolean jaiRecycling = form.getJaiRecycling();
        if (!form.isJaiRecyclingChecked()) {
            jaiRecycling = false;
        }
        boolean imageIOCache = form.getImageIOCache();
        if (!form.isImageIOCacheChecked()) {
            imageIOCache = false;
        }
        boolean jaiJPEGNative = form.getJaiJPEGNative();
        if (!form.isJaiJPEGNativeChecked()) {
            jaiJPEGNative = false;
        }
        boolean jaiPNGNative = form.getJaiPNGNative();
        if (!form.isJaiPNGNativeChecked()) {
            jaiPNGNative = false;
        }
        GlobalConfig globalConfig = this.getGlobalConfig();
        globalConfig.setMaxFeatures(maxFeatures);
        globalConfig.setVerbose(verbose);
        globalConfig.setNumDecimals(numDecimals);
        globalConfig.setProxyBaseUrl(baseURL);
        globalConfig.setSchemaBaseUrl(schemaBaseURL);
        globalConfig.setCharSet(charset);
        globalConfig.setAdminUserName(adminUserName);
        globalConfig.setAdminPassword(adminPassword);
        globalConfig.setLoggingLevel(loggingLevel);
        globalConfig.setLoggingToFile(loggingToFile);
        globalConfig.setLogLocation(logLocation);
        globalConfig.setVerboseExceptions(verboseExceptions);
        globalConfig.setJaiMemoryCapacity(jaiMemoryCapacity);
        globalConfig.setJaiMemoryThreshold(jaiMemoryThreshold);
        globalConfig.setJaiTileThreads(jaiTileThreads);
        globalConfig.setJaiTilePriority(jaiTilePriority);
        globalConfig.setJaiRecycling(jaiRecycling);
        globalConfig.setImageIOCache(imageIOCache);
        globalConfig.setJaiJPEGNative(jaiJPEGNative);
        globalConfig.setJaiPNGNative(jaiPNGNative);
        ContactConfig contactConfig = globalConfig.getContact();
        contactConfig.setContactPerson(form.getContactPerson());
        contactConfig.setContactOrganization(form.getContactOrganization());
        contactConfig.setContactPosition(form.getContactPosition());
        contactConfig.setAddressType(form.getAddressType());
        contactConfig.setAddress(form.getAddress());
        contactConfig.setAddressCity(form.getAddressCity());
        contactConfig.setAddressCountry(form.getAddressCountry());
        contactConfig.setAddressPostalCode(form.getAddressPostalCode());
        contactConfig.setAddressState(form.getAddressState());
        contactConfig.setContactVoice(form.getContactVoice());
        contactConfig.setContactFacsimile(form.getContactFacsimile());
        contactConfig.setContactEmail(form.getContactEmail());
        globalConfig.setContact(contactConfig);
        this.getApplicationState().notifyConfigChanged();
        this.getServlet().getServletContext().setAttribute("Config.Global", (Object)globalConfig);
        return mapping.findForward("config");
    }
}

