/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import com.sun.media.jai.util.SunTileCache;
import javax.media.jai.JAI;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;

public class AdminIndexAction
extends ConfigAction {
    private static final String JAI_TILE_PRIORITY = "JAI_TILE_PRIORITY";
    private static final String JAI_TILE_THREADS = "JAI_TILE_THREADS";
    private static final String JAI_MEM_THRESHOLD = "JAI_MEM_THRESHOLD";
    private static final String JAI_MEM_USED = "JAI_MEM_USED";
    private static final String JAI_MEM_CAPACITY = "JAI_MEM_CAPACITY";

    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext sc = request.getSession().getServletContext();
        JAI jaiDef = ((GeoServer)sc.getAttribute("GeoServer")).getJAIDefault();
        SunTileCache jaiCache = ((GeoServer)sc.getAttribute("GeoServer")).getJaiCache();
        long memCapacity = jaiCache.getMemoryCapacity() / 1024L;
        long memUsed = jaiCache.getCacheMemoryUsed() / 1024L;
        float memThreshold = jaiCache.getMemoryThreshold() * 100.0f;
        int numThreads = jaiDef.getTileScheduler().getParallelism();
        int priiority = jaiDef.getTileScheduler().getPriority();
        request.setAttribute(JAI_MEM_CAPACITY, (Object)new Long(memCapacity));
        request.setAttribute(JAI_MEM_USED, (Object)new Long(memUsed));
        request.setAttribute(JAI_MEM_THRESHOLD, (Object)new Float(memThreshold));
        request.setAttribute(JAI_TILE_THREADS, (Object)new Integer(numThreads));
        request.setAttribute(JAI_TILE_PRIORITY, (Object)new Integer(priiority));
        return mapping.findForward("admin.main");
    }
}

