<?xml version="1.0"?>
<xsl:stylesheet xmlns:wmc="http://www.opengis.net/context" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"><xsl:output method="xml" omit-xml-declaration="yes"/><xsl:strip-space elements="*"/><xsl:param name="modelId"/><xsl:param name="widgetId"/><xsl:param name="context">config['<xsl:value-of select="$modelId"/>']</xsl:param><xsl:param name="extraAttributes">true</xsl:param><xsl:param name="isIE">false</xsl:param><xsl:param name="outputNodeId"/><xsl:param name="bbox"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@minx"/>,<xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@miny"/>,
    <xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@maxx"/>,<xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@maxy"/></xsl:param><xsl:param name="width"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:Window/@width"/></xsl:param><xsl:param name="height"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:Window/@height"/></xsl:param><xsl:param name="srs" select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@SRS"/><xsl:param name="timeList"/><xsl:param name="timeListName"/><xsl:param name="uniqueId"/><xsl:template match="/wmc:ViewContext"><DIV STYLE="position:absolute; width:{$width}; height:{$height}" ID="{$outputNodeId}"><xsl:apply-templates select="wmc:LayerList/wmc:Layer"/></DIV></xsl:template><xsl:template match="wmc:Layer"><xsl:choose><xsl:when test="$timeList and wmc:DimensionList/wmc:Dimension[@name='time']"><xsl:call-template name="tokenize"><xsl:with-param name="str" select="$timeList"/><xsl:with-param name="sep" select="','"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="layerOutput"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="wmc:StyledLayerDescriptor"><xsl:apply-templates mode="serialize" select="."/></xsl:template><xsl:template name="layerOutput"><xsl:param name="version"><xsl:value-of select="wmc:Server/@version"/></xsl:param><xsl:param name="baseUrl"><xsl:value-of select="wmc:Server/wmc:OnlineResource/@xlink:href"/></xsl:param><xsl:param name="timestamp"><xsl:value-of select="wmc:DimensionList/wmc:Dimension[@name='time']/@default"/></xsl:param><xsl:param name="metadataUrl"><xsl:value-of select="wmc:MetadataURL/wmc:OnlineResource/@xlink:href"/></xsl:param><xsl:param name="format"><xsl:choose><xsl:when test="wmc:FormatList"><xsl:value-of select="wmc:FormatList/wmc:Format[@current='1']"/></xsl:when><xsl:otherwise>image/gif</xsl:otherwise></xsl:choose></xsl:param><xsl:param name="visibility"><xsl:choose><xsl:when test="starts-with($isIE,'true') and $format='image/png'">hidden</xsl:when><xsl:when test="@hidden='1'">hidden</xsl:when><xsl:otherwise>visible</xsl:otherwise></xsl:choose></xsl:param><xsl:variable name="styleParam"><xsl:choose><xsl:when test="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:OnlineResource">
          SLD=<xsl:value-of select="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:OnlineResource/@xlink:href"/></xsl:when><xsl:when test="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:StyledLayerDescriptor">
          SLD_BODY=<xsl:apply-templates select="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:StyledLayerDescriptor"/></xsl:when><xsl:when test="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:FeatureTypeStyle">
          SLD=<xsl:value-of select="wmc:StyleList/wmc:Style[@current='1']/wmc:SLD/wmc:FeatureTypeStyle"/></xsl:when><xsl:otherwise>
          STYLES=<xsl:value-of select="wmc:StyleList/wmc:Style[@current='1']/wmc:Name"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="firstJoin"><xsl:choose><xsl:when test="substring($baseUrl,string-length($baseUrl))='?'"/><xsl:when test="contains($baseUrl, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="mapRequest"><xsl:choose><xsl:when test="starts-with($version, '1.0')">
            WMTVER=<xsl:value-of select="$version"/>&amp;REQUEST=map
        </xsl:when><xsl:otherwise>
            VERSION=<xsl:value-of select="$version"/>&amp;REQUEST=GetMap&amp;SERVICE=WMS
        </xsl:otherwise></xsl:choose></xsl:variable><DIV><xsl:attribute name="STYLE">position:absolute; visibility:<xsl:value-of select="$visibility"/>; top:0; left:0;</xsl:attribute><xsl:attribute name="ID"><xsl:value-of select="$modelId"/>_<xsl:value-of select="$widgetId"/>_<xsl:value-of select="wmc:Name"/><xsl:if test="$timestamp and wmc:DimensionList/wmc:Dimension[@name='time']">_<xsl:value-of select="$timestamp"/></xsl:if></xsl:attribute><xsl:if test="$timestamp and wmc:DimensionList/wmc:Dimension[@name='time']"><xsl:attribute name="TIME"><xsl:value-of select="$timestamp"/></xsl:attribute></xsl:if><xsl:element name="IMG"><xsl:variable name="src"><xsl:value-of select="$baseUrl"/><xsl:value-of select="$firstJoin"/><xsl:value-of select="$mapRequest"/>
   &amp;SRS=<xsl:value-of select="$srs"/>
  &amp;BBOX=<xsl:value-of select="$bbox"/>
 &amp;WIDTH=<xsl:value-of select="$width"/>
&amp;HEIGHT=<xsl:value-of select="$height"/>
&amp;LAYERS=<xsl:value-of select="wmc:Name"/>
&amp;FORMAT=<xsl:value-of select="$format"/>
       &amp;<xsl:value-of select="$styleParam"/>
&amp;TRANSPARENT=TRUE
        <xsl:if test="string-length($timestamp)&gt;0">
       &amp;TIME=<xsl:value-of select="$timestamp"/></xsl:if>
        &amp;UNIQUEID=<xsl:value-of select="$uniqueId"/></xsl:variable><xsl:attribute name="SRC"><xsl:value-of select="translate(normalize-space($src),' ', '' )" disable-output-escaping="no"/></xsl:attribute><xsl:attribute name="WIDTH"><xsl:value-of select="$width"/></xsl:attribute><xsl:attribute name="HEIGHT"><xsl:value-of select="$height"/></xsl:attribute><xsl:if test="starts-with($extraAttributes,'true')"><xsl:attribute name="ALT"><xsl:value-of select="wmc:Title"/></xsl:attribute><xsl:attribute name="TITLE"><xsl:value-of select="wmc:Title"/></xsl:attribute><xsl:if test="string-length($metadataUrl)&gt;0"><xsl:attribute name="LONGDESC"><xsl:value-of select="$metadataUrl"/></xsl:attribute></xsl:if></xsl:if></xsl:element></DIV></xsl:template><xsl:template name="tokenize"><xsl:param name="str"/><xsl:param name="sep"/><xsl:choose><xsl:when test="contains($str,$sep)"><xsl:call-template name="process-token"><xsl:with-param name="token" select="substring-before($str,$sep)"/></xsl:call-template><xsl:call-template name="tokenize"><xsl:with-param name="str" select="substring-after($str,$sep)"/><xsl:with-param name="sep" select="$sep"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="process-token"><xsl:with-param name="token" select="$str"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="process-token"><xsl:param name="token"/><xsl:call-template name="layerOutput"><xsl:with-param name="timestamp" select="$token"/><xsl:with-param name="visibility">hidden</xsl:with-param></xsl:call-template></xsl:template><xsl:template name="replace-string"><xsl:param name="text"/><xsl:param name="replace"/><xsl:param name="with"/><xsl:choose><xsl:when test="contains($text,$replace)"><xsl:value-of select="substring-before($text,$replace)"/><xsl:value-of select="$with"/><xsl:call-template name="replace-string"><xsl:with-param name="text" select="substring-after($text,$replace)"/><xsl:with-param name="replace" select="$replace"/><xsl:with-param name="with" select="$with"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="escape-uri"><xsl:param name="text"/><xsl:param name="tmp"><xsl:call-template name="replace-string"><xsl:with-param name="text" select="$text"/><xsl:with-param name="replace" select="' '"/><xsl:with-param name="with" select="'%20'"/></xsl:call-template></xsl:param><xsl:call-template name="replace-string"><xsl:with-param name="text" select="$tmp"/><xsl:with-param name="replace" select="'#'"/><xsl:with-param name="with" select="'%23'"/></xsl:call-template></xsl:template><xsl:template match="*" mode="serialize"><xsl:param name="count"><xsl:value-of select="count(*)"/></xsl:param><xsl:param name="value"><xsl:apply-templates mode="serialize"/></xsl:param><xsl:text/>%3C<xsl:value-of select="name()"/><xsl:apply-templates select="@*" mode="serialize"/>%3E<xsl:text/><xsl:choose><xsl:when test="$count=0"><xsl:call-template name="escape-uri"><xsl:with-param name="text" select="$value"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise></xsl:choose><xsl:text/>%3C/<xsl:value-of select="name()"/>%3E<xsl:text/></xsl:template><xsl:template match="@*" mode="serialize"><xsl:param name="value"><xsl:value-of select="."/></xsl:param>
  %20<xsl:value-of select="name()"/>=%22
  <xsl:call-template name="escape-uri"><xsl:with-param name="text" select="$value"/></xsl:call-template>%22
</xsl:template></xsl:stylesheet>
