<?xml version="1.0"?>
<xsl:stylesheet xmlns:gml="http://www.opengis.net/gml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"><xsl:template match="gml:coordinates"><xsl:variable name="str" select="translate(.,@decimal,'.')"/><xsl:variable name="str2" select="translate($str,@cs,',')"/><xsl:variable name="str3" select="translate($str2,@ts,' ')"/><xsl:if test="string-length(normalize-space($str3))!=0"><xsl:call-template name="parseTuples"><xsl:with-param name="str" select="normalize-space($str3)"/></xsl:call-template></xsl:if></xsl:template><xsl:template name="parseTuples"><xsl:param name="str"/><xsl:param name="cs" select="','"/><xsl:param name="ts" select="' '"/><xsl:choose><xsl:when test="not(contains($str,$ts))"><xsl:call-template name="parseCoords"><xsl:with-param name="str" select="$str"/><xsl:with-param name="cs" select="$cs"/><xsl:with-param name="ts" select="$ts"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="parseCoords"><xsl:with-param name="str" select="substring-before($str,$ts)"/><xsl:with-param name="cs" select="$cs"/><xsl:with-param name="ts" select="$ts"/></xsl:call-template><xsl:call-template name="parseTuples"><xsl:with-param name="str" select="substring-after($str,$ts)"/><xsl:with-param name="cs" select="$cs"/><xsl:with-param name="ts" select="$ts"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:template><xsl:template name="parseCoords"><xsl:param name="str"/><xsl:param name="cs"/><gml:coord><xsl:choose><xsl:when test="not(contains($str,$cs))"><xsl:call-template name="printCoord"><xsl:with-param name="coord" select="'gml:X'"/><xsl:with-param name="value" select="$str"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="printCoord"><xsl:with-param name="coord" select="'gml:X'"/><xsl:with-param name="value" select="substring-before($str,$cs)"/></xsl:call-template><xsl:variable name="yz" select="substring-after($str,$cs)"/><xsl:choose><xsl:when test="not(contains($yz,$cs))"><xsl:call-template name="printCoord"><xsl:with-param name="coord" select="'gml:Y'"/><xsl:with-param name="value" select="$yz"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="printCoord"><xsl:with-param name="coord" select="'gml:Y'"/><xsl:with-param name="value" select="substring-before($yz,$cs)"/></xsl:call-template><xsl:call-template name="printCoord"><xsl:with-param name="coord" select="'gml:Z'"/><xsl:with-param name="value" select="substring-after($yz,$cs)"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:otherwise></xsl:choose></gml:coord></xsl:template><xsl:template name="printCoord"><xsl:param name="coord"/><xsl:param name="value"/><xsl:element name="{$coord}"><xsl:value-of select="$value"/></xsl:element></xsl:template><xsl:template match="*|@*|comment()|processing-instruction()|text()"><xsl:copy><xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"/></xsl:copy></xsl:template></xsl:stylesheet>
