<?xml version="1.0"?>
<xsl:stylesheet xmlns:wps="http://www.opengis.net/wps" xmlns:ogc="http://www.opengis.net/ogc" xmlns:ows="http://www.opengis.net/ows" xmlns:mb="http://mapbuilder.sourceforge.net/mapbuilder" xmlns:gml="http://www.opengis.net/gml" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"><xsl:output method="xml" omit-xml-declaration="no" encoding="utf-8" indent="yes"/><xsl:param name="httpMethod">get</xsl:param><xsl:param name="version"/><xsl:param name="processName"/><xsl:param name="store">false</xsl:param><xsl:template match="wps:Process"><wps:Execute version="{$version}" service="WPS"><xsl:attribute name="store"><xsl:value-of select="$store"/></xsl:attribute><xsl:choose><xsl:when test="$httpMethod='post'"><wps:ProcessName><xsl:value-of select="$processName"/></wps:ProcessName></xsl:when><xsl:otherwise><mb:QueryString><xsl:variable name="query">
        request=Execute
   &amp;service=WPS
   &amp;version=<xsl:value-of select="$version"/>
  &amp;ProcessName=<xsl:value-of select="wps:Name"/><xsl:apply-templates select="wps:Input"/></xsl:variable><xsl:value-of select="translate(normalize-space($query),' ', '' )" disable-output-escaping="no"/></mb:QueryString></xsl:otherwise></xsl:choose><xsl:apply-templates select="wps:Output"/></wps:Execute></xsl:template><xsl:template match="wps:Output/wps:Parameter">
    &amp;<xsl:value-of select="wps:Name"/>=<xsl:apply-templates select="wps:Datatype"/></xsl:template><xsl:template match="wps:Input/wps:Parameter">
    &amp;<xsl:value-of select="wps:Name"/>=<xsl:apply-templates select="wps:Datatype"/></xsl:template><xsl:template match="wps:Datatype/wps:Reference"><xsl:value-of select="@xlink:href"/></xsl:template><xsl:template match="wps:Datatype/wps:LiteralValue"><xsl:value-of select="."/></xsl:template><xsl:template match="wps:Datatype/wps:ComplexValue"><xsl:value-of select="."/></xsl:template><xsl:template match="wps:Datatype/wps:BoundingBox"><xsl:value-of select="."/></xsl:template><xsl:template match="text()|@*"/></xsl:stylesheet>
