/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureType;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.form.data.DataFeatureTypesNewForm;
import org.vfny.geoserver.global.UserContainer;

public class DataFeatureTypesNewAction
extends ConfigAction {
    public static final String NEW_FEATURE_TYPE_KEY = "newFeatureType";

    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FeatureTypeConfig ftConfig;
        DataFeatureTypesNewForm form = (DataFeatureTypesNewForm)incomingForm;
        String selectedNewFeatureType = form.getSelectedNewFeatureType();
        DataConfig dataConfig = (DataConfig)request.getSession().getServletContext().getAttribute("Config.Data");
        int index = selectedNewFeatureType.indexOf(":::");
        String dataStoreID = selectedNewFeatureType.substring(0, index);
        String featureTypeName = selectedNewFeatureType.substring(index + ":::".length());
        DataStoreConfig dsConfig = dataConfig.getDataStore(dataStoreID);
        DataStore dataStore = dsConfig.findDataStore(request.getSession().getServletContext());
        try {
            FeatureType featureType;
            block5: {
                featureType = dataStore.getSchema(featureTypeName);
                ftConfig = new FeatureTypeConfig(dataStoreID, featureType, false);
                ftConfig.setSRS(0);
                try {
                    CoordinateReferenceSystem crs = featureType.getDefaultGeometry().getCoordinateSystem();
                    if (crs == null) break block5;
                    Set idents = crs.getIdentifiers();
                    Iterator it = idents.iterator();
                    while (it.hasNext()) {
                        Identifier id = (Identifier)it.next();
                        if (id.toString().indexOf("EPSG:") == -1) continue;
                        String str_num = id.toString().substring(id.toString().indexOf(58) + 1);
                        int num = Integer.parseInt(str_num);
                        ftConfig.setSRS(num);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            FeatureSource fs = dataStore.getFeatureSource(featureType.getTypeName());
        }
        catch (IOException e) {
            e.printStackTrace();
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.exception", (Object)e.getMessage()));
            this.saveErrors(request, errors);
            return mapping.findForward("config.data.type.new");
        }
        request.getSession().setAttribute("selectedFeatureType", (Object)ftConfig);
        request.getSession().removeAttribute("selectedAttributeType");
        user.setFeatureTypeConfig(ftConfig);
        return mapping.findForward("config.data.type.editor");
    }
}

