/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.geotools.validation.xml.XMLWriter;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.XMLConfigWriter;

public class SaveXMLAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward r1 = this.saveGeoserver(mapping, form, request, response);
        ActionForward r2 = this.saveValidation(mapping, form, request, response);
        this.getApplicationState(request).notifiySaveXML();
        return mapping.findForward("config");
    }

    private ActionForward saveGeoserver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory((ServletContext)sc);
        try {
            XMLConfigWriter.store((WMSDTO)((WMSDTO)this.getWMS(request).toDTO()), (WFSDTO)((WFSDTO)this.getWFS(request).toDTO()), (GeoServerDTO)((GeoServerDTO)this.getWFS(request).getGeoServer().toDTO()), (DataDTO)((DataDTO)this.getWFS(request).getData().toDTO()), (File)rootDir);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        return mapping.findForward("config");
    }

    private ActionForward saveValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        File[] testsFL;
        Object dto;
        File validationDir;
        File plugInDir;
        ServletContext sc = request.getSession().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory((ServletContext)sc);
        File dataDir = GeoserverDataDirectory.isTrueDataDir() ? rootDir : new File(rootDir, "data/");
        try {
            plugInDir = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(dataDir, "plugIns"), (boolean)true);
            validationDir = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(dataDir, "validation"), (boolean)true);
        }
        catch (ConfigurationException confE) {
            throw new ServletException((Throwable)confE);
        }
        Map plugIns = (Map)this.getWFS(request).getValidation().toPlugInDTO();
        Map testSuites = (Map)this.getWFS(request).getValidation().toTestSuiteDTO();
        Iterator i = null;
        if (plugIns != null) {
            i = plugIns.keySet().iterator();
            while (i.hasNext()) {
                dto = null;
                Object key = null;
                try {
                    key = i.next();
                    dto = (PlugInDTO)plugIns.get(key);
                    String fName = dto.getName().replaceAll(" ", "") + ".xml";
                    File pFile = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(plugInDir, fName), (boolean)false);
                    FileWriter fw = new FileWriter(pFile);
                    XMLWriter.writePlugIn((PlugInDTO)dto, (Writer)fw);
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
            }
        }
        if (testSuites != null) {
            i = testSuites.keySet().iterator();
            while (i.hasNext()) {
                dto = null;
                try {
                    dto = (TestSuiteDTO)testSuites.get(i.next());
                    String fName = dto.getName().replaceAll(" ", "") + ".xml";
                    File pFile = XMLConfigWriter.WriterUtils.initWriteFile((File)new File(validationDir, fName), (boolean)false);
                    FileWriter fw = new FileWriter(pFile);
                    XMLWriter.writeTestSuite((TestSuiteDTO)dto, (Writer)fw);
                    fw.close();
                }
                catch (Exception e) {
                    System.err.println(dto.getClass());
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
            }
        }
        if ((testsFL = validationDir.listFiles()) != null) {
            for (int j = 0; j < testsFL.length; ++j) {
                boolean found = false;
                i = testSuites.keySet().iterator();
                while (!found && i.hasNext()) {
                    found = (((TestSuiteDTO)testSuites.get(i.next())).getName().replaceAll(" ", "") + ".xml").equals(testsFL[j].getName());
                }
                if (found) continue;
                testsFL[j].delete();
            }
        }
        this.getApplicationState(request).notifiySaveXML();
        return mapping.findForward("config.validation");
    }
}

