/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.geotools.data.DataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureType;
import org.geotools.referencing.FactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.AttributeDisplay;
import org.vfny.geoserver.form.data.AttributeForm;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.util.Requests;

/*
 * Exception performing whole class analysis ignored.
 */
public class TypesEditorForm
extends ActionForm {
    static final List schemaBases;
    static final List allMetadataURLTypes;
    private String dataStoreId;
    private String styleId;
    private String typeName;
    private String wmsPath;
    private String SRS;
    private String SRSWKT;
    private String title;
    private String minX;
    private String minY;
    private String maxX;
    private String maxY;
    private String keywords;
    private MetaDataLink[] metadataLinks;
    private String[] metadataURLTypes;
    private String description;
    private String cacheMaxAge;
    private boolean cachingEnabled;
    private boolean cachingEnabledChecked = false;
    private String schemaBase;
    private String schemaName;
    private List attributes;
    private List addList;
    private String action;
    private SortedSet styles;
    private String newAttribute;
    private String dataMinX;
    private String dataMinY;
    private String dataMaxX;
    private String dataMaxY;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CRSAuthorityFactory;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.dataMinX = "";
        this.dataMinY = "";
        this.dataMaxX = "";
        this.dataMaxY = "";
        this.action = "";
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        FeatureTypeConfig type = user.getFeatureTypeConfig();
        if (type == null) {
            System.out.println("Type is not there");
            return;
        }
        this.dataStoreId = type.getDataStoreId();
        this.styleId = type.getDefaultStyle();
        this.description = type.getAbstract();
        this.cacheMaxAge = type.getCacheMaxAge();
        this.cachingEnabled = type.isCachingEnabled();
        this.cachingEnabledChecked = false;
        Envelope bounds = type.getLatLongBBox();
        if (bounds == null || bounds.isNull()) {
            this.minX = "";
            this.minY = "";
            this.maxY = "";
            this.maxX = "";
        } else {
            this.minX = Double.toString(bounds.getMinX());
            this.minY = Double.toString(bounds.getMinY());
            this.maxX = Double.toString(bounds.getMaxX());
            this.maxY = Double.toString(bounds.getMaxY());
        }
        this.typeName = type.getName();
        this.setSRS(Integer.toString(type.getSRS()));
        this.title = type.getTitle();
        this.wmsPath = type.getWmsPath();
        System.out.println("rest based on schemaBase: " + type.getSchemaBase());
        DataStoreConfig dataStoreConfig = config.getDataStore(this.dataStoreId);
        FeatureType featureType = null;
        try {
            DataStore dataStore = dataStoreConfig.findDataStore(this.getServlet().getServletContext());
            featureType = dataStore.getSchema(this.typeName);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (type.getSchemaBase() == null || "--".equals(type.getSchemaBase()) || type.getSchemaAttributes() == null) {
            this.schemaBase = "--";
            this.schemaName = this.typeName + "_Type";
            this.attributes = new LinkedList();
            List generated = DataTransferObjectFactory.generateAttributes((FeatureType)featureType);
            this.attributes = this.attributesDisplayList(generated);
            this.addList = Collections.EMPTY_LIST;
        } else {
            this.schemaBase = type.getSchemaBase();
            this.schemaName = type.getSchemaName();
            this.attributes = new LinkedList();
            List schemaAttributes = DataTransferObjectFactory.generateRequiredAttributes((String)this.schemaBase);
            this.attributes.addAll(this.attributesDisplayList(schemaAttributes));
            this.attributes.addAll(this.attributesFormList(type.getSchemaAttributes(), featureType));
            this.addList = new ArrayList(featureType.getAttributeCount());
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                String attributeName = featureType.getAttributeType(i).getName();
                if (this.lookUpAttribute(attributeName) != null) continue;
                this.addList.add(attributeName);
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator<Object> i = type.getKeywords().iterator();
        while (i.hasNext()) {
            String keyword = (String)i.next();
            buf.append(keyword);
            if (!i.hasNext()) continue;
            buf.append(" ");
        }
        this.keywords = buf.toString();
        this.metadataLinks = new MetaDataLink[2];
        this.metadataLinks[0] = new MetaDataLink();
        this.metadataLinks[0].setType("text/plain");
        this.metadataLinks[1] = new MetaDataLink();
        this.metadataLinks[1].setType("text/plain");
        if (type.getMetadataLinks() != null && type.getMetadataLinks().size() > 0) {
            ArrayList links = new ArrayList(type.getMetadataLinks());
            MetaDataLink link = (MetaDataLink)links.get(0);
            this.metadataLinks[0] = new MetaDataLink(link);
            if (links.size() > 1) {
                link = (MetaDataLink)links.get(1);
                this.metadataLinks[1] = new MetaDataLink(link);
            }
        }
        this.styles = new TreeSet();
        i = config.getStyles().values().iterator();
        while (i.hasNext()) {
            StyleConfig sc = (StyleConfig)i.next();
            this.styles.add(sc.getId());
            if (!sc.isDefault() || this.styleId != null && !this.styleId.equals("")) continue;
            this.styleId.equals(sc.getId());
        }
        SortedSet attribute = this.styles;
        if (attribute instanceof AttributeDisplay) {
            // empty if block
        }
    }

    private Object lookUpAttribute(String name) {
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Object attribute = i.next();
            if (attribute instanceof AttributeDisplay && name.equals(((AttributeDisplay)attribute).getName())) {
                return attribute;
            }
            if (!(attribute instanceof AttributeForm) || !name.equals(((AttributeForm)attribute).getName())) continue;
            return attribute;
        }
        return null;
    }

    private List attributesDisplayList(List dtoList) {
        ArrayList<AttributeDisplay> list = new ArrayList<AttributeDisplay>();
        int index = 0;
        Iterator i = dtoList.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            list.add(new AttributeDisplay(new AttributeTypeInfoConfig((AttributeTypeInfoDTO)next)));
            ++index;
        }
        return list;
    }

    private List attributesFormList(List dtoList, FeatureType schema) {
        ArrayList<AttributeForm> list = new ArrayList<AttributeForm>();
        Iterator i = dtoList.iterator();
        while (i.hasNext()) {
            AttributeTypeInfoConfig config = (AttributeTypeInfoConfig)i.next();
            list.add(new AttributeForm(config, schema.getAttributeType(config.getName())));
        }
        return list;
    }

    public List toSchemaAttributes() {
        if (this.schemaBase == null || this.schemaBase.equals("--")) {
            return null;
        }
        ArrayList<AttributeTypeInfoConfig> list = new ArrayList<AttributeTypeInfoConfig>();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof AttributeForm)) continue;
            AttributeForm form = (AttributeForm)obj;
            list.add(form.toConfig());
        }
        return list;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        Locale locale = request.getLocale();
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String BBOX = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String SLDWIZARD = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.sldWizard.label"));
        if (this.action.startsWith("Up") || this.action.startsWith("Down") || this.action.startsWith("Remove") || this.action.equals(BBOX) || this.action.equals(SLDWIZARD)) {
            return errors;
        }
        DataConfig data = ConfigRequests.getDataConfig((HttpServletRequest)request);
        if (!data.getStyles().containsKey(this.styleId) && !"".equals(this.styleId)) {
            errors.add("styleId", new ActionError("error.styleId.notFound", (Object)this.styleId));
        }
        if ("".equals(this.minX) || "".equals(this.minY) || "".equals(this.maxX) || "".equals(this.maxY)) {
            errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.required"));
        } else {
            try {
                Double.parseDouble(this.minX);
                Double.parseDouble(this.minY);
                Double.parseDouble(this.maxX);
                Double.parseDouble(this.maxY);
            }
            catch (NumberFormatException badNumber) {
                errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.invalid", (Object)badNumber));
            }
        }
        if (this.isCachingEnabled()) {
            try {
                Integer.parseInt(this.cacheMaxAge);
            }
            catch (NumberFormatException nfe) {
                errors.add("cacheMaxAge", new ActionError("error.cacheMaxAge.malformed", (Object)nfe));
            }
            catch (Throwable t) {
                errors.add("cacheMaxAge", new ActionError("error.cacheMaxAge.error", (Object)t));
            }
        }
        return errors;
    }

    public List getAllYourBase() {
        return schemaBases;
    }

    public List getAllMetadataURLTypes() {
        return allMetadataURLTypes;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public void setDataStoreId(String dataStoreId) {
        this.dataStoreId = dataStoreId;
    }

    public String getAbstract() {
        return this.description;
    }

    public void setAbstract(String description) {
        this.description = description;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public MetaDataLink getMetadataLink(int index) {
        return this.metadataLinks[index];
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String schemaBase) {
        this.schemaBase = schemaBase;
    }

    public String getSRS() {
        return this.SRS;
    }

    public String getSRSWKT() {
        return this.SRSWKT;
    }

    public void setSRS(String srs) {
        this.SRS = srs;
        try {
            String newSrs = srs;
            if (newSrs.indexOf(58) == -1) {
                newSrs = "EPSG:" + srs;
            }
            CRSAuthorityFactory crsFactory = FactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, (Object)(class$org$opengis$referencing$crs$CRSAuthorityFactory == null ? (class$org$opengis$referencing$crs$CRSAuthorityFactory = TypesEditorForm.class$((String)"org.opengis.referencing.crs.CRSAuthorityFactory")) : class$org$opengis$referencing$crs$CRSAuthorityFactory)));
            CoordinateReferenceSystem crsTheirData = crsFactory.createCoordinateReferenceSystem(newSrs);
            this.SRSWKT = crsTheirData.toWKT();
        }
        catch (FactoryException e) {
            this.SRSWKT = "Could not find a definition for: EPSG:" + srs;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMaxX() {
        return this.maxX;
    }

    public void setMaxX(String maxX) {
        this.maxX = maxX;
    }

    public String getMaxY() {
        return this.maxY;
    }

    public void setMaxY(String maxY) {
        this.maxY = maxY;
    }

    public String getMinX() {
        return this.minX;
    }

    public void setMinX(String minX) {
        this.minX = minX;
    }

    public String getMinY() {
        return this.minY;
    }

    public void setMinY(String minY) {
        this.minY = minY;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public SortedSet getStyles() {
        return this.styles;
    }

    public void setStyles(SortedSet styles) {
        this.styles = styles;
    }

    public Object getAttribute(int index) {
        return this.attributes.get(index);
    }

    public void setAttribute(int index, Object attribute) {
        this.attributes.set(index, attribute);
    }

    public String getNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(String newAttribute) {
        this.newAttribute = newAttribute;
    }

    public List getCreateableAttributes() {
        return this.addList;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDataMinX(String x) {
        this.dataMinX = x;
    }

    public void setDataMinY(String x) {
        this.dataMinY = x;
    }

    public void setDataMaxX(String x) {
        this.dataMaxX = x;
    }

    public void setDataMaxY(String x) {
        this.dataMaxY = x;
    }

    public String getDataMinX() {
        return this.dataMinX;
    }

    public String getDataMinY() {
        return this.dataMinY;
    }

    public String getDataMaxX() {
        return this.dataMaxX;
    }

    public String getDataMaxY() {
        return this.dataMaxY;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabledChecked = true;
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isCachingEnabledChecked() {
        return this.cachingEnabledChecked;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList<String> bases = new ArrayList<String>();
        bases.add("--");
        bases.addAll(DataTransferObjectFactory.schemaBaseMap.keySet());
        schemaBases = Collections.unmodifiableList(bases);
        allMetadataURLTypes = Arrays.asList("FGDC", "TC211");
    }
}

