/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.NameSpaceConfig;
import org.vfny.geoserver.util.Requests;

public class DataNamespacesEditorForm
extends ActionForm {
    private String URI;
    private boolean _default;
    private String prefix;
    private HttpServletRequest request;
    private boolean defaultChecked = false;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        super.reset(arg0, request);
        this.request = request;
        this.defaultChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        DataConfig config = (DataConfig)context.getAttribute("Config.Data");
        NameSpaceConfig nsConfig = Requests.getUserContainer((HttpServletRequest)request).getNamespaceConfig();
        this._default = nsConfig.isDefault();
        this.prefix = nsConfig.getPrefix();
        this.URI = nsConfig.getUri();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.prefix == null || this.prefix.equals("")) {
            errors.add("prefix", new ActionError("error.prefix.required", (Object)this.getPrefix()));
        } else if (!Pattern.matches("^\\w*$", this.prefix)) {
            errors.add("dataStoreID", new ActionError("error.prefix.invalid", (Object)this.prefix));
        }
        if (this.URI == null || this.URI.equals("")) {
            errors.add("URI", new ActionError("error.uri.required", (Object)this.prefix));
        } else {
            try {
                URL url = new URL(this.URI);
            }
            catch (MalformedURLException badURI) {
                errors.add("dataStoreID", new ActionError("error.uri.malformed", (Object)badURI));
            }
        }
        return errors;
    }

    public boolean is_default() {
        return this._default;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.URI;
    }

    public void set_default(boolean b) {
        this.defaultChecked = true;
        this._default = b;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setURI(String string) {
        this.URI = string;
    }

    public boolean isDefaultChecked() {
        return this.defaultChecked;
    }

    public void setDefaultChecked(boolean b) {
        this.defaultChecked = b;
    }
}

