/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.StylesSelectForm;
import org.vfny.geoserver.global.UserContainer;

public class StylesSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StylesSelectForm selectForm = (StylesSelectForm)form;
        String action = selectForm.getAction();
        String styleId = selectForm.getSelectedStyle();
        if (styleId.endsWith("*")) {
            styleId = styleId.substring(0, styleId.lastIndexOf("*"));
        }
        Locale locale = request.getLocale();
        DataConfig config = this.getDataConfig();
        MessageResources messages = this.getResources(request);
        String EDIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String DELETE = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        String DEFAULT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.default"));
        StyleConfig style = config.getStyle(styleId);
        if (style == null) {
            ActionErrors errors = new ActionErrors();
            errors.add("selectedStyle", new ActionError("error.style.invalid", (Object)styleId));
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
            return mapping.findForward("config.data.style");
        }
        if (action.equals(DELETE)) {
            config.removeStyle(styleId);
            this.getApplicationState().notifyConfigChanged();
            selectForm.setSelectedStyle(null);
            selectForm.reset(mapping, request);
            return mapping.findForward("config.data.style");
        }
        if (action.equals(DEFAULT)) {
            Map m = config.getStyles();
            Iterator i = m.values().iterator();
            while (i.hasNext()) {
                StyleConfig sc = (StyleConfig)i.next();
                if (sc.isDefault()) {
                    if (sc.getId() == null || sc.getId().equals(styleId)) continue;
                    sc.setDefault(false);
                    this.getApplicationState().notifyConfigChanged();
                    continue;
                }
                if (sc.getId() == null || !sc.getId().equals(styleId)) continue;
                sc.setDefault(true);
                this.getApplicationState().notifyConfigChanged();
            }
            selectForm.setSelectedStyle(null);
            selectForm.reset(mapping, request);
            return mapping.findForward("config.data.style");
        }
        if (action.equals(EDIT)) {
            user.setStyle(new StyleConfig(style));
            return mapping.findForward("config.data.style.editor");
        }
        ActionErrors errors = new ActionErrors();
        errors.add("submit", new ActionError("error.action.invalid", (Object)action));
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        return mapping.findForward("config.data.style");
    }
}

