/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SrsHelpAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ArrayList<String> defs = new ArrayList<String>();
        ArrayList<String> ids_string = new ArrayList<String>();
        Set codes = CRS.getSupportedCodes((String)"EPSG");
        int[] ids = new int[codes.size()];
        int t = 0;
        Iterator codeIt = codes.iterator();
        while (codeIt.hasNext()) {
            String code = (String)codeIt.next();
            String id = code.substring(code.indexOf(58) + 1);
            ids[t] = Integer.parseInt(id);
            ++t;
        }
        Arrays.sort(ids);
        for (t = 0; t < ids.length; ++t) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + ids[t]));
                String def = crs.toWKT();
                defs.add(def);
                ids_string.add("" + ids[t]);
                continue;
            }
            catch (Exception e) {
                System.out.println("tried to parse projection EPSG:" + ids[t] + " but couldnt!");
            }
        }
        DynaActionForm myForm = (DynaActionForm)form;
        myForm.set("srsDefinitionList", (Object)defs.toArray(new String[1]));
        myForm.set("srsIDList", (Object)ids_string.toArray(new String[1]));
        return mapping.findForward("success");
    }
}

