<?xml version="1.0"?>
<xsl:stylesheet xmlns:wmc="http://www.opengis.net/context" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"><xsl:output method="xml"/><xsl:strip-space elements="*"/><xsl:param name="queryLayer">highways</xsl:param><xsl:param name="xCoord">1</xsl:param><xsl:param name="yCoord">1</xsl:param><xsl:param name="infoFormat">text/html</xsl:param><xsl:param name="featureCount">1</xsl:param><xsl:variable name="bbox"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@minx"/>,<xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@miny"/>,<xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@maxx"/>,<xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@maxy"/></xsl:variable><xsl:variable name="width"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:Window/@width"/></xsl:variable><xsl:variable name="height"><xsl:value-of select="/wmc:ViewContext/wmc:General/wmc:Window/@height"/></xsl:variable><xsl:variable name="srs" select="/wmc:ViewContext/wmc:General/wmc:BoundingBox/@SRS"/><xsl:template match="/"><url><xsl:apply-templates select="wmc:ViewContext/wmc:LayerList"/><error>URL not calculated for layer=<xsl:value-of select="$queryLayer"/></error></url></xsl:template><xsl:template match="wmc:Layer"><xsl:if test="contains($queryLayer,wmc:Name)"><xsl:variable name="version"><xsl:value-of select="wmc:Server/@version"/></xsl:variable><xsl:variable name="baseUrl"><xsl:value-of select="wmc:Server/wmc:OnlineResource/@xlink:href"/></xsl:variable><xsl:variable name="firstJoin"><xsl:choose><xsl:when test="substring($baseUrl,string-length($baseUrl))='?'"/><xsl:when test="contains($baseUrl, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose></xsl:variable><xsl:value-of select="$baseUrl"/><xsl:value-of select="$firstJoin"/>VERSION=<xsl:value-of select="$version"/>&amp;REQUEST=GetFeatureInfo&amp;LAYERS=<xsl:value-of select="$queryLayer"/>&amp;SRS=<xsl:value-of select="$srs"/>&amp;BBOX=<xsl:value-of select="$bbox"/>&amp;WIDTH=<xsl:value-of select="$width"/>&amp;HEIGHT=<xsl:value-of select="$height"/>&amp;INFO_FORMAT=<xsl:value-of select="$infoFormat"/>&amp;FEATURE_COUNT=<xsl:value-of select="$featureCount"/>&amp;QUERY_LAYERS=<xsl:value-of select="$queryLayer"/>&amp;X=<xsl:value-of select="$xCoord"/>&amp;Y=<xsl:value-of select="$yCoord"/></xsl:if></xsl:template></xsl:stylesheet>
