/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.validation;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.validation.ArgumentConfig;
import org.vfny.geoserver.config.validation.PlugInConfig;
import org.vfny.geoserver.config.validation.TestConfig;
import org.vfny.geoserver.config.validation.ValidationConfig;

public class ValidationTestEditorForm
extends ActionForm {
    private String name;
    private String description;
    private String plugInName;
    private HttpServletRequest request;
    private List attributeKeys;
    private List attributeHelps;
    private List attributeValues;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        super.reset(arg0, request);
        this.request = request;
        TestConfig testConfig = (TestConfig)request.getSession().getAttribute("selectedTest");
        this.name = testConfig.getName();
        this.description = testConfig.getDescription();
        this.plugInName = testConfig.getPlugIn().getName();
        this.attributeKeys = new ArrayList();
        this.attributeHelps = new ArrayList();
        this.attributeValues = new ArrayList();
        ArgumentConfig.loadPropertyLists((TestConfig)testConfig, (Locale)request.getLocale(), (List)this.attributeKeys, (List)this.attributeHelps, (List)this.attributeValues);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        TestConfig victim = (TestConfig)request.getSession().getAttribute("selectedTest");
        ActionErrors errors = new ActionErrors();
        int i = 0;
        while (i < this.attributeKeys.size()) {
            String key = (String)this.attributeKeys.get(i);
            String text = (String)this.attributeValues.get(i);
            PropertyDescriptor property = victim.getPropertyDescriptor(key);
            if (text == null || text.length() == 0) {
                if (property.isPreferred()) {
                    errors.add(key, new ActionError("validation.test.property.required", (Object)key));
                }
            } else {
                try {
                    Object value = victim.createArg(key, text);
                    if (value == null && property.isPreferred()) {
                        errors.add(key, new ActionError("validation.test.property.required", (Object)key));
                    }
                }
                catch (Throwable t) {
                    errors.add(key, new ActionError("validation.test.property.invalid", (Object)key, (Object)t));
                }
            }
            ++i;
        }
        return errors;
    }

    public Map toArgumentMap(TestConfig victim) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < this.attributeKeys.size()) {
            String key = (String)this.attributeKeys.get(i);
            String text = (String)this.attributeValues.get(i);
            PropertyDescriptor property = victim.getPropertyDescriptor(this.name);
            if ((text == null || text.length() == 0) && property.isPreferred()) {
                throw new IllegalArgumentException("Required non empty value for " + key);
            }
            Object value = victim.createArg(key, text);
            if (value == null) {
                if (property.isPreferred()) {
                    throw new IllegalArgumentException("Required non empty value for " + key);
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        return map;
    }

    public List getAttributeKeys() {
        return this.attributeKeys;
    }

    public List getAttributeValues() {
        return this.attributeValues;
    }

    public String[] getAttributeHelps() {
        return this.attributeHelps.toArray(new String[this.attributeHelps.size()]);
    }

    public String getAttributeKey(int index) {
        return (String)this.attributeKeys.get(index);
    }

    public void setAttributeValues(List list) {
        this.attributeValues = list;
    }

    public void setAttributeKeys(List list) {
        this.attributeKeys = list;
    }

    public void setAttributeHelps(List list) {
        this.attributeHelps = list;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlugInName() {
        return this.plugInName;
    }

    public String getPlugInDescription() {
        ValidationConfig validationConfig = (ValidationConfig)this.getServlet().getServletContext().getAttribute("Validation.Config");
        PlugInConfig config = validationConfig.getPlugIn(this.plugInName);
        return config.getDescription();
    }
}

