/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.FactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.form.data.AttributeForm;
import org.vfny.geoserver.form.data.TypesEditorForm;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.DataStoreUtils;

public class TypesEditorAction
extends ConfigAction {
    static /* synthetic */ Class class$0;

    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("form bean:" + form.getClass().getName());
        }
        TypesEditorForm typeForm = (TypesEditorForm)form;
        String action = typeForm.getAction();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("TypesEditorAction is " + action);
        }
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String SUBMIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.submit"));
        String ADD = HTMLEncoder.decode((String)messages.getMessage(locale, "label.add"));
        String BBOX = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("BBOX: " + BBOX);
        }
        String NEWSLD = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.sldWizard.label"));
        if (action.equals(SUBMIT)) {
            return this.executeSubmit(mapping, typeForm, user, request);
        }
        if (action.equals(BBOX)) {
            return this.executeBBox(mapping, typeForm, user, request);
        }
        if (action.equals(NEWSLD)) {
            return mapping.findForward("SLDWizard");
        }
        List attributes = typeForm.getAttributes();
        if (action.startsWith("up_")) {
            int index = Integer.parseInt(action.substring(3));
            Object attribute = attributes.remove(index);
            attributes.add(index - 1, attribute);
        } else if (action.startsWith("down_")) {
            int index = Integer.parseInt(action.substring(5));
            Object attribute = attributes.remove(index);
            attributes.add(index + 1, attribute);
        } else if (action.startsWith("delete_")) {
            int index = Integer.parseInt(action.substring(7));
            attributes.remove(index);
        } else if (action.equals(ADD)) {
            this.executeAdd(mapping, typeForm, user, request);
        }
        this.sync(typeForm, user.getFeatureTypeConfig(), request);
        form.reset(mapping, request);
        return mapping.findForward("config.data.type.editor");
    }

    private ActionForward executeBBox(ActionMapping mapping, TypesEditorForm typeForm, UserContainer user, HttpServletRequest request) throws IOException, ServletException {
        Envelope envelope;
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dsConfig = dataConfig.getDataStore(typeForm.getDataStoreId());
        DataStore dataStore = dsConfig.findDataStore(request.getSession().getServletContext());
        FeatureType featureType = dataStore.getSchema(typeForm.getTypeName());
        FeatureSource fs = dataStore.getFeatureSource(featureType.getTypeName());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("calculating bbox for their dataset");
        }
        if ((envelope = DataStoreUtils.getBoundingBoxEnvelope((FeatureSource)fs)).isNull()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("FeatureType '" + featureType.getTypeName() + "' has a null bounding box");
            }
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.nullBBOX", (Object)featureType.getTypeName()));
            this.saveErrors(request, errors);
            return mapping.findForward("config.data.type.editor");
        }
        typeForm.setDataMinX(Double.toString(envelope.getMinX()));
        typeForm.setDataMaxX(Double.toString(envelope.getMaxX()));
        typeForm.setDataMinY(Double.toString(envelope.getMinY()));
        typeForm.setDataMaxY(Double.toString(envelope.getMaxY()));
        String srs = typeForm.getSRS();
        if (srs.indexOf(58) == -1) {
            srs = "EPSG:" + srs;
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.opengis.referencing.crs.CRSAuthorityFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CRSAuthorityFactory crsFactory = FactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, (Object)clazz));
            CoordinateReferenceSystem crsTheirData = crsFactory.createCoordinateReferenceSystem(srs);
            CoordinateReferenceSystem crsLatLong = crsFactory.createCoordinateReferenceSystem("EPSG:4326");
            MathTransform xform = CRS.transform((CoordinateReferenceSystem)crsTheirData, (CoordinateReferenceSystem)crsLatLong, (boolean)true);
            Envelope xformed_envelope = JTS.transform((Envelope)envelope, (MathTransform)xform, (int)10);
            typeForm.setMinX(Double.toString(xformed_envelope.getMinX()));
            typeForm.setMaxX(Double.toString(xformed_envelope.getMaxX()));
            typeForm.setMinY(Double.toString(xformed_envelope.getMinY()));
            typeForm.setMaxY(Double.toString(xformed_envelope.getMaxY()));
        }
        catch (NoSuchAuthorityCodeException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(e.getLocalizedMessage());
                LOGGER.fine(e.getStackTrace().toString());
            }
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.couldNotFindSRSAuthority", (Object)e.getLocalizedMessage(), (Object)e.getAuthorityCode()));
            this.saveErrors(request, errors);
            return mapping.findForward("config.data.type.editor");
        }
        catch (FactoryException fe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(fe.getLocalizedMessage());
                LOGGER.fine(fe.getStackTrace().toString());
            }
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.factoryException", (Object)fe.getLocalizedMessage()));
            this.saveErrors(request, errors);
            return mapping.findForward("config.data.type.editor");
        }
        catch (TransformException te) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(te.getLocalizedMessage());
                LOGGER.fine(te.getStackTrace().toString());
            }
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.transformException"));
            this.saveErrors(request, errors);
            return mapping.findForward("config.data.type.editor");
        }
        return mapping.findForward("config.data.type.editor");
    }

    private void sync(TypesEditorForm form, FeatureTypeConfig config, HttpServletRequest request) {
        String schemaBase;
        config.setName(form.getTypeName());
        config.setAbstract(form.getAbstract());
        config.setDefaultStyle(form.getStyleId());
        config.setSRS(Integer.parseInt(form.getSRS()));
        config.setTitle(form.getTitle());
        config.setLatLongBBox(this.getBoundingBox(form));
        config.setKeywords(this.keyWords(form));
        config.setWmsPath(form.getWmsPath());
        config.setCacheMaxAge(form.getCacheMaxAge());
        config.setCachingEnabled(form.isCachingEnabled());
        if (!form.isCachingEnabledChecked()) {
            config.setCachingEnabled(false);
        }
        if ((schemaBase = form.getSchemaBase()) == null || schemaBase.equals("") || schemaBase.equals("--")) {
            config.setSchemaBase(null);
            config.setSchemaName(null);
            config.setSchemaAttributes(null);
        } else {
            config.setSchemaBase(schemaBase);
            String schemaName = config.getSchemaName();
            ArrayList<AttributeTypeInfoConfig> schemaAttributes = config.getSchemaAttributes();
            System.out.println("in non null sb, sname: " + schemaName + ", satts: " + schemaAttributes);
            if (schemaName == null || schemaName.trim().length() == 0) {
                schemaName = String.valueOf(form.getTypeName()) + "_Type";
                schemaAttributes = null;
                config.setSchemaName(schemaName);
            } else {
                config.setSchemaName(form.getSchemaName());
            }
            if (schemaAttributes == null || schemaAttributes.isEmpty()) {
                schemaAttributes = new ArrayList<AttributeTypeInfoConfig>();
                List createList = form.getCreateableAttributes();
                System.out.println("schemaAtts null, createList: " + createList);
                FeatureType fType = this.getFeatureType(form, request);
                int i = 0;
                while (i < fType.getAttributeCount()) {
                    AttributeType attType = fType.getAttributeType(i);
                    AttributeTypeInfoConfig attributeConfig = new AttributeTypeInfoConfig(attType);
                    schemaAttributes.add(attributeConfig);
                    ++i;
                }
                config.setSchemaAttributes(schemaAttributes);
            } else {
                config.setSchemaAttributes(form.toSchemaAttributes());
            }
        }
        LOGGER.fine("config schema atts is " + config.getSchemaAttributes());
    }

    private void executeAdd(ActionMapping mapping, TypesEditorForm form, UserContainer user, HttpServletRequest request) {
        String attributeName = form.getNewAttribute();
        FeatureType fType = this.getFeatureType(form, request);
        AttributeForm newAttribute = this.newAttributeForm(attributeName, fType);
        form.getAttributes().add(newAttribute);
    }

    private AttributeForm newAttributeForm(String attributeName, FeatureType featureType) {
        AttributeType attributeType = featureType.getAttributeType(attributeName);
        AttributeTypeInfoConfig attributeConfig = new AttributeTypeInfoConfig(attributeType);
        AttributeForm newAttribute = new AttributeForm(attributeConfig, attributeType);
        return newAttribute;
    }

    private FeatureType getFeatureType(TypesEditorForm form, HttpServletRequest request) {
        FeatureType featureType = null;
        try {
            DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
            DataStoreConfig dataStoreConfig = config.getDataStore(form.getDataStoreId());
            DataStore dataStore = dataStoreConfig.findDataStore(this.getServlet().getServletContext());
            featureType = dataStore.getSchema(form.getTypeName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return featureType;
    }

    private ActionForward executeSubmit(ActionMapping mapping, TypesEditorForm form, UserContainer user, HttpServletRequest request) {
        FeatureTypeConfig config = user.getFeatureTypeConfig();
        this.sync(form, config, request);
        DataConfig dataConfig = this.getDataConfig();
        dataConfig.addFeatureType(String.valueOf(config.getDataStoreId()) + ":" + config.getName(), config);
        this.getApplicationState().notifyConfigChanged();
        user.setFeatureTypeConfig(null);
        return mapping.findForward("config.data.type");
    }

    private Envelope getBoundingBox(TypesEditorForm typeForm) {
        return new Envelope(Double.parseDouble(typeForm.getMinX()), Double.parseDouble(typeForm.getMaxX()), Double.parseDouble(typeForm.getMinY()), Double.parseDouble(typeForm.getMaxY()));
    }

    private Set keyWords(TypesEditorForm typeForm) {
        HashSet<String> keywords = new HashSet<String>();
        String[] array = typeForm.getKeywords() != null ? typeForm.getKeywords().split(System.getProperty("line.separator")) : new String[]{};
        int i = 0;
        while (i < array.length) {
            keywords.add(array[i]);
            ++i;
        }
        return keywords;
    }

    DataStore aquireDataStore(String dataStoreID) throws IOException {
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dataStoreConfig = dataConfig.getDataStore(dataStoreID);
        Map params = dataStoreConfig.getConnectionParams();
        return DataStoreFinder.getDataStore((Map)params);
    }

    FeatureType getSchema(String dataStoreID, String typeName) throws IOException {
        DataStore dataStore = this.aquireDataStore(dataStoreID);
        return dataStore.getSchema(typeName);
    }
}

