/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.StylesEditorForm;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.SAXParseException;

public class StylesEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Style newStyle;
        int charsRead;
        File styleDir;
        List l;
        DataConfig config = this.getDataConfig();
        StylesEditorForm stylesForm = (StylesEditorForm)form;
        FormFile file = stylesForm.getSldFile();
        String filename = file.getFileName();
        String styleID = stylesForm.getStyleID();
        StyleConfig style = user.getStyle();
        boolean doFullValidation = stylesForm.getFullyValidate();
        if (!stylesForm.getFullyValidateChecked()) {
            doFullValidation = false;
        }
        if (doFullValidation && (l = this.getSchemaExceptions(file, request)).size() != 0) {
            this.handleValidationErrors(l, file, stylesForm);
            return mapping.findForward("schemaErrors");
        }
        if (style == null) {
            return mapping.findForward("config.data.style");
        }
        ServletContext sc = this.getServlet().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory((ServletContext)sc);
        try {
            styleDir = GeoserverDataDirectory.findConfigDir((File)rootDir, (String)"styles");
        }
        catch (ConfigurationException cfe) {
            LOGGER.warning("no style dir found, creating new one");
            styleDir = new File(rootDir, "styles");
        }
        InputStreamReader isr = new InputStreamReader(file.getInputStream());
        File newSldFile = new File(styleDir, filename);
        LOGGER.fine("new sld file is: " + newSldFile + ", exists: " + newSldFile.exists());
        if (newSldFile.exists()) {
            StyleConfig styleForID = config.getStyle(styleID);
            if (styleForID == null) {
                this.doFileExistsError(newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
            File oldFile = styleForID.getFilename();
            LOGGER.fine("old file: " + oldFile + ", newFile: " + newSldFile);
            if (!oldFile.equals(newSldFile)) {
                this.doFileExistsError(newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
        }
        FileWriter fw = new FileWriter(newSldFile);
        char[] tampon = new char[1024];
        while ((charsRead = isr.read(tampon, 0, 1024)) != -1) {
            fw.write(tampon, 0, charsRead);
        }
        fw.flush();
        fw.close();
        isr.close();
        style.setFilename(new File(styleDir, filename));
        style.setId(styleID);
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        SLDParser styleReader = new SLDParser(factory, newSldFile.toURL());
        Style[] readStyles = null;
        try {
            readStyles = styleReader.readXML();
            if (readStyles.length == 0) {
                String message = "The xml was valid, but couldn't get a Style from it.  Make sure your style validates against  the SLD schema";
                this.doStyleParseError(message, newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
            newStyle = readStyles[0];
            LOGGER.fine("sld is " + newStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage();
            this.doStyleParseError(message, newSldFile, request);
            return mapping.findForward("config.data.style.editor");
        }
        if (newStyle == null) {
            throw new RuntimeException("new style equals null");
        }
        config.addStyle(style.getId(), style);
        this.getApplicationState().notifyConfigChanged();
        return mapping.findForward("config.data.style");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleValidationErrors(List errors, FormFile file, StylesEditorForm stylesForm) {
        block18: {
            lines = new ArrayList<String>();
            reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
                    line = reader.readLine();
                    linenumber = 1;
                    exceptionNum = 0;
                    if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                        lines.add("   INVALID XML: " + sax.getLocalizedMessage());
                        lines.add(" ");
                        exceptionNum = 1;
                    }
                    block8: while (true) {
                        if (line == null) {
                            t = exceptionNum;
                            break;
                        }
                        line.replace('\n', ' ');
                        line.replace('\r', ' ');
                        header = String.valueOf(linenumber) + ": ";
                        lines.add(String.valueOf(header) + line);
                        keep_going = true;
                        while (true) {
                            if (!keep_going) {
                                line = reader.readLine();
                                ++linenumber;
                                continue block8;
                            }
                            if (exceptionNum < errors.size()) {
                                sax = (SAXParseException)errors.get(exceptionNum);
                                if (sax.getLineNumber() <= linenumber) {
                                    head = "---------------------".substring(0, header.length() - 1);
                                    body = "------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                                    colNum = sax.getColumnNumber();
                                    if (colNum < 1) {
                                        colNum = 1;
                                    }
                                    lines.add(String.valueOf(head) + body.substring(0, sax.getColumnNumber() - 1) + "^");
                                    lines.add("       " + sax.getLocalizedMessage());
                                    ++exceptionNum;
                                    continue;
                                }
                                keep_going = false;
                                continue;
                            }
                            keep_going = false;
                        }
                        break;
                    }
                    while (t < errors.size()) {
                        sax = (SAXParseException)errors.get(t);
                        lines.add("       " + sax.getLocalizedMessage());
                        ++t;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable var16_19) {
                var15_20 = null;
                try {
                    if (reader == null) throw var16_19;
                    reader.close();
                    throw var16_19;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw var16_19;
            }
            {
                var15_21 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 453->466)] { 
lbl72:
            // 1 sources

            if (reader != null) {
                reader.close();
            }
            break block18;
lbl75:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stylesForm.setValidationReport(lines.toArray(new String[1]));
    }

    private List getSchemaExceptions(FormFile file, HttpServletRequest request) {
        SLDValidator validator = new SLDValidator();
        ServletContext sc = request.getSession().getServletContext();
        try {
            List l = validator.validateSLD(file.getInputStream(), sc);
            return l;
        }
        catch (Exception e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private void doStyleParseError(String message, File newSldFile, HttpServletRequest request) {
        LOGGER.fine("parse error message is: " + message);
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.noParse", (Object)message));
        this.saveErrors(request, errors);
        newSldFile.delete();
    }

    private void doFileExistsError(File file, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.sldFileExists", (Object)file.getName()));
        this.saveErrors(request, errors);
    }
}

