/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.StylesEditorForm;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.SAXParseException;

public class StylesEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Style newStyle;
        int charsRead;
        File styleDir;
        List l;
        DataConfig config = this.getDataConfig();
        StylesEditorForm stylesForm = (StylesEditorForm)form;
        FormFile file = stylesForm.getSldFile();
        String filename = file.getFileName();
        String styleID = stylesForm.getStyleID();
        StyleConfig style = user.getStyle();
        boolean doFullValidation = stylesForm.getFullyValidate();
        if (!stylesForm.getFullyValidateChecked()) {
            doFullValidation = false;
        }
        if (doFullValidation && (l = this.getSchemaExceptions(file, request)).size() != 0) {
            this.handleValidationErrors(l, file, stylesForm);
            return mapping.findForward("schemaErrors");
        }
        if (style == null) {
            return mapping.findForward("config.data.style");
        }
        ServletContext sc = this.getServlet().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory((ServletContext)sc);
        try {
            styleDir = GeoserverDataDirectory.findConfigDir((File)rootDir, (String)"styles");
        }
        catch (ConfigurationException cfe) {
            GeoServerAction.LOGGER.warning("no style dir found, creating new one");
            styleDir = new File(rootDir, "styles");
        }
        InputStreamReader isr = new InputStreamReader(file.getInputStream());
        File newSldFile = new File(styleDir, filename);
        GeoServerAction.LOGGER.fine("new sld file is: " + newSldFile + ", exists: " + newSldFile.exists());
        if (newSldFile.exists()) {
            StyleConfig styleForID = config.getStyle(styleID);
            if (styleForID == null) {
                this.doFileExistsError(newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
            File oldFile = styleForID.getFilename();
            GeoServerAction.LOGGER.fine("old file: " + oldFile + ", newFile: " + newSldFile);
            if (!oldFile.equals(newSldFile)) {
                this.doFileExistsError(newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
        }
        FileWriter fw = new FileWriter(newSldFile);
        char[] tampon = new char[1024];
        while ((charsRead = isr.read(tampon, 0, 1024)) != -1) {
            fw.write(tampon, 0, charsRead);
        }
        fw.flush();
        fw.close();
        isr.close();
        style.setFilename(new File(styleDir, filename));
        style.setId(styleID);
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        SLDParser styleReader = new SLDParser(factory, newSldFile.toURL());
        Style[] readStyles = null;
        try {
            readStyles = styleReader.readXML();
            if (readStyles.length == 0) {
                String message = "The xml was valid, but couldn't get a Style from it.  Make sure your style validates against  the SLD schema";
                this.doStyleParseError(message, newSldFile, request);
                return mapping.findForward("config.data.style.editor");
            }
            newStyle = readStyles[0];
            GeoServerAction.LOGGER.fine("sld is " + newStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getCause() == null ? e.getLocalizedMessage() : e.getCause().getLocalizedMessage();
            this.doStyleParseError(message, newSldFile, request);
            return mapping.findForward("config.data.style.editor");
        }
        if (newStyle == null) {
            throw new RuntimeException("new style equals null");
        }
        config.addStyle(style.getId(), style);
        this.getApplicationState().notifyConfigChanged();
        return mapping.findForward("config.data.style");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleValidationErrors(List errors, FormFile file, StylesEditorForm stylesForm) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            SAXParseException sax;
            reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
            String line = reader.readLine();
            int linenumber = 1;
            int exceptionNum = 0;
            if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                lines.add("   INVALID XML: " + sax.getLocalizedMessage());
                lines.add(" ");
                exceptionNum = 1;
            }
            while (line != null) {
                line.replace('\n', ' ');
                line.replace('\r', ' ');
                String header = linenumber + ": ";
                lines.add(header + line);
                boolean keep_going = true;
                while (keep_going) {
                    if (exceptionNum < errors.size()) {
                        SAXParseException sax2 = (SAXParseException)errors.get(exceptionNum);
                        if (sax2.getLineNumber() <= linenumber) {
                            String head = "---------------------".substring(0, header.length() - 1);
                            String body = "------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                            int colNum = sax2.getColumnNumber();
                            if (colNum < 1) {
                                colNum = 1;
                            }
                            lines.add(head + body.substring(0, sax2.getColumnNumber() - 1) + "^");
                            lines.add("       " + sax2.getLocalizedMessage());
                            ++exceptionNum;
                            continue;
                        }
                        keep_going = false;
                        continue;
                    }
                    keep_going = false;
                }
                line = reader.readLine();
                ++linenumber;
            }
            for (int t = exceptionNum; t < errors.size(); ++t) {
                SAXParseException sax3 = (SAXParseException)errors.get(t);
                lines.add("       " + sax3.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        stylesForm.setValidationReport(lines.toArray(new String[1]));
    }

    private List getSchemaExceptions(FormFile file, HttpServletRequest request) {
        SLDValidator validator = new SLDValidator();
        ServletContext sc = request.getSession().getServletContext();
        try {
            List l = validator.validateSLD(file.getInputStream(), sc);
            return l;
        }
        catch (Exception e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private void doStyleParseError(String message, File newSldFile, HttpServletRequest request) {
        GeoServerAction.LOGGER.fine("parse error message is: " + message);
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.noParse", (Object)message));
        this.saveErrors(request, errors);
        newSldFile.delete();
    }

    private void doFileExistsError(File file, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.style.sldFileExists", (Object)file.getName()));
        this.saveErrors(request, errors);
    }
}

