/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.NameSpaceConfig;
import org.vfny.geoserver.form.data.DataNamespacesSelectForm;
import org.vfny.geoserver.global.UserContainer;

public class DataNamespacesSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DataNamespacesSelectForm namespacesForm = (DataNamespacesSelectForm)form;
        String action = namespacesForm.getAction();
        DataConfig dataConfig = this.getDataConfig();
        NameSpaceConfig config = null;
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String edit = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String delete = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        String _default = HTMLEncoder.decode((String)messages.getMessage(locale, "label.default"));
        String nsSelected = namespacesForm.getSelectedNamespace();
        if (nsSelected.endsWith("*")) {
            nsSelected = nsSelected.substring(0, nsSelected.lastIndexOf("*"));
        }
        if ((config = dataConfig.getNameSpace(nsSelected)) == null) {
            throw new NullPointerException();
        }
        this.getUserContainer(request).setNamespaceConfig(config);
        if (action.equals(delete)) {
            if (this.dataStoresUseNamespace(dataConfig, nsSelected)) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.namespace.namespaceInUse"));
                request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
                return mapping.findForward("config.data.namespace");
            }
            dataConfig.removeNameSpace(nsSelected);
            this.getApplicationState().notifyConfigChanged();
            this.getUserContainer(request).setNamespaceConfig(null);
            namespacesForm.reset(mapping, request);
            return mapping.findForward("config.data.namespace");
        }
        if (action.equals(_default)) {
            if (!nsSelected.equals(dataConfig.getDefaultNameSpace().getPrefix())) {
                dataConfig.setDefaultNameSpace(dataConfig.getNameSpace(nsSelected));
                this.getApplicationState().notifyConfigChanged();
            }
            this.getUserContainer(request).setNamespaceConfig(null);
            namespacesForm.reset(mapping, request);
            return mapping.findForward("config.data.namespace");
        }
        if (action.equals(edit)) {
            this.getUserContainer(request).setNamespaceConfig(config);
            return mapping.findForward("config.data.namespace.editor");
        }
        ActionErrors errors = new ActionErrors();
        errors.add("submit", new ActionError("error.action.invalid", (Object)action));
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        return mapping.findForward("config.data.style");
    }

    private boolean dataStoresUseNamespace(DataConfig dataConfig, String nsSelected) {
        List stores = dataConfig.getDataStoreIds();
        Iterator it = stores.iterator();
        while (it.hasNext()) {
            DataStoreConfig dsc = dataConfig.getDataStore((String)it.next());
            if (!dsc.getNameSpaceId().equals(nsSelected)) continue;
            return true;
        }
        return false;
    }
}

