/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.form.data.DataDataStoresEditorForm;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataDataStoresEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionErrors errors;
        DataDataStoresEditorForm dataStoresForm = (DataDataStoresEditorForm)form;
        String dataStoreID = dataStoresForm.getDataStoreId();
        String namespace = dataStoresForm.getNamespaceId();
        String description = dataStoresForm.getDescription();
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig config = null;
        config = dataConfig.getDataStore(dataStoreID);
        if (config == null) {
            dataConfig.addDataStore(this.getUserContainer(request).getDataStoreConfig());
            config = dataConfig.getDataStore(dataStoreID);
        }
        HashMap<String, Object> connectionParams = new HashMap<String, Object>();
        HashMap<String, String> paramTexts = new HashMap<String, String>();
        Map params = dataStoresForm.getParams();
        DataStoreFactorySpi factory = config.getFactory();
        DataStoreFactorySpi.Param[] info = factory.getParametersInfo();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            String key = (String)i.next();
            DataStoreFactorySpi.Param param = DataStoreUtils.find((DataStoreFactorySpi.Param[])info, (String)key);
            if (param == null) {
                errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.cannotProcessConnectionParams"));
                this.saveErrors(request, errors);
                return mapping.findForward("config.data.store.editor");
            }
            try {
                value = param.lookUp(params);
            }
            catch (IOException erp) {
                ActionErrors errors2 = new ActionErrors();
                errors2.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.cannotProcessConnectionParams"));
                this.saveErrors(request, errors2);
                return mapping.findForward("config.data.store.editor");
            }
            if (value == null) continue;
            connectionParams.put(key, value);
            String text = param.text(value);
            paramTexts.put(key, text);
        }
        connectionParams.put("namespace", dataStoresForm.getNamespaceId());
        paramTexts.put("namespace", dataStoresForm.getNamespaceId());
        if (!factory.canProcess(connectionParams)) {
            ActionErrors errors3 = new ActionErrors();
            errors3.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.cannotProcessConnectionParams"));
            this.saveErrors(request, errors3);
            return mapping.findForward("config.data.store.editor");
        }
        try {
            ServletContext sc = request.getSession().getServletContext();
            Map niceParams = DataStoreUtils.getParams(connectionParams, (ServletContext)sc);
            DataStore victim = factory.createDataStore(niceParams);
            if (victim == null) {
                errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.invalidConnectionParams"));
                this.saveErrors(request, errors);
                return mapping.findForward("config.data.store.editor");
            }
            Object[] typeNames = victim.getTypeNames();
            this.dump("typeNames", typeNames);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ActionErrors errors4 = new ActionErrors();
            errors4.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.exception", (Object)throwable.getMessage()));
            this.saveErrors(request, errors4);
            return mapping.findForward("config.data.store.editor");
        }
        boolean enabled = dataStoresForm.isEnabled();
        if (!dataStoresForm.isEnabledChecked()) {
            enabled = false;
        }
        config.setEnabled(enabled);
        config.setNameSpaceId(namespace);
        config.setAbstract(description);
        config.setConnectionParams(paramTexts);
        dataConfig.addDataStore(config);
        this.getUserContainer(request).setDataStoreConfig(null);
        this.getApplicationState().notifyConfigChanged();
        return mapping.findForward("config.data.store");
    }

    public void dump(String msg, Map params) {
        if (msg != null) {
            System.out.print(msg + " ");
        }
        System.out.print(": { ");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            System.out.print(entry.getKey());
            System.out.print("=");
            this.dump(entry.getValue());
            if (!i.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public void dump(Object obj) {
        if (obj == null) {
            System.out.print("null");
        } else if (obj instanceof String) {
            System.out.print("\"");
            System.out.print(obj);
            System.out.print("\"");
        } else {
            System.out.print(obj);
        }
    }

    public void dump(String msg, Object[] array) {
        if (msg != null) {
            System.out.print(msg + " ");
        }
        System.out.print(": ");
        if (array == null) {
            System.out.print("null");
            return;
        }
        System.out.print("(");
        for (int i = 0; i < array.length; ++i) {
            this.dump(array[i]);
            if (i >= array.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println(")");
    }
}

