/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.geotools.feature.FeatureType;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.global.xml.ReaderUtils;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wms.servlets.Capabilities;

public class MapPreviewAction
extends GeoServerAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ArrayList<String> dsList = new ArrayList<String>();
        ArrayList<String> ftList = new ArrayList<String>();
        ArrayList<String> bboxList = new ArrayList<String>();
        ArrayList<String> ftnsList = new ArrayList<String>();
        WMS wms = this.getWMS(request);
        Capabilities caps = new Capabilities(wms);
        CapabilitiesRequest capRequest = new CapabilitiesRequest("WMS", (AbstractService)caps);
        capRequest.setHttpServletRequest(request);
        Data catalog = wms.getData();
        Collection ftypes = catalog.getFeatureTypeInfos().values();
        ServletContext sc = request.getSession().getServletContext();
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory((ServletContext)sc);
        File previewDir = new File(sc.getRealPath("data/generated"));
        if (!previewDir.exists()) {
            previewDir.mkdirs();
        }
        try {
            this.emptyGeneratedDirectory(previewDir);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        Iterator it = ftypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo layer = (FeatureTypeInfo)it.next();
            Envelope bbox = layer.getLatLongBoundingBox();
            if (!layer.isEnabled()) continue;
            ftList.add(layer.getNameSpace().getPrefix() + "_" + layer.getFeatureType().getTypeName());
            ftnsList.add(layer.getNameSpace().getPrefix() + ":" + layer.getFeatureType().getTypeName());
            dsList.add(layer.getDataStoreInfo().getId());
            bboxList.add(bbox.getMinX() + ", " + bbox.getMinY() + ", " + bbox.getMaxX() + ", " + bbox.getMaxY());
            this.makeMapBuilderFiles(previewDir, layer, bbox);
        }
        DynaActionForm myForm = (DynaActionForm)form;
        myForm.set("DSNameList", (Object)dsList.toArray(new String[dsList.size()]));
        myForm.set("FTNameList", (Object)ftList.toArray(new String[ftList.size()]));
        myForm.set("BBoxList", (Object)bboxList.toArray(new String[bboxList.size()]));
        myForm.set("FTNamespaceList", (Object)ftnsList.toArray(new String[ftnsList.size()]));
        return mapping.findForward("success");
    }

    private void emptyGeneratedDirectory(File dir) throws FileNotFoundException, ConfigurationException {
        String[] files = (dir = ReaderUtils.checkFile((File)dir, (boolean)true)).list();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                this.emptyGeneratedDirectory(f);
                continue;
            }
            if (!f.exists() || f.delete()) continue;
            throw new FileNotFoundException("could not delete file: " + f.getName());
        }
    }

    private void makeMapBuilderFiles(File previewDir, FeatureTypeInfo layer, Envelope bbox) throws FileNotFoundException, IOException {
        FeatureType featureType = layer.getFeatureType();
        String ft_name = featureType.getTypeName();
        String ft_namespace = layer.getNameSpace().getPrefix();
        File html_file = new File(previewDir, ft_namespace + "_" + ft_name + ".html");
        File config_file = new File(previewDir, ft_namespace + "_" + ft_name + "Config.xml");
        File xml_file = new File(previewDir, ft_namespace + "_" + ft_name + ".xml");
        FileOutputStream html_fos = new FileOutputStream(html_file);
        PrintStream html_out = new PrintStream(html_fos);
        this.createIndexHTML(html_out, ft_name, ft_namespace);
        html_out.close();
        FileOutputStream config_fos = new FileOutputStream(config_file);
        PrintStream config_out = new PrintStream(config_fos);
        this.createConfigXML(config_out, ft_name, ft_namespace);
        config_out.close();
        FileOutputStream xml_fos = new FileOutputStream(xml_file);
        PrintStream xml_out = new PrintStream(xml_fos);
        this.createLayersXML(xml_out, ft_name, ft_namespace, bbox);
        xml_out.close();
    }

    private void createIndexHTML(PrintStream out, String ft_name, String ft_namespace) {
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        out.println("<!--");
        out.println("Description: A Browser based Transactional Web Feature Server client");
        out.println("             based on javascript and XSL");
        out.println("             libraries from http://mapbuilder.sourceforge.net .");
        out.println("Licence:     GPL as per: http://www.gnu.org/copyleft/gpl.html");
        out.println("-->");
        out.println("");
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + ft_namespace + ":" + ft_name + " Preview</title>");
        out.println("");
        out.println("<link rel=\"stylesheet\" href=\"../../style.css\"");
        out.println("\ttype=\"text/css\">");
        out.println("<link rel=\"stylesheet\" href=\"../mbdemos/lib/skin/default/html.css\"");
        out.println("\ttype=\"text/css\">");
        out.println("");
        out.println("<script type=\"text/javascript\">");
        out.println("      // URL of Mapbuilder configuration file.");
        out.println("      var mbConfigUrl='" + ft_namespace + "_" + ft_name + "Config.xml" + "';");
        out.println("    </script>");
        out.println("<script type=\"text/javascript\" src=\"../mbdemos/lib/Mapbuilder.js\"></script>");
        out.println("</head>");
        out.println("");
        out.println("<body onload=\"mbDoLoad()\">");
        out.println("<!-- Layout mapbuilder widgets and HTML -->");
        out.println("<h2><a href=\"http://geoserver.sf.net\">GeoServer</a>/<a");
        out.println("\thref=\"http://mapbuilder.sourceforge.net\">Map Builder</a>");
        out.println("" + ft_namespace + ":" + ft_name + " preview</h2>");
        out.println("");
        out.println("<table border=\"0\">");
        out.println("\t<tr>");
        out.println("\t\t<td valign=\"top\" id=\"locatorMap\" style=\"background-color: white;\" />");
        out.println("\t\t<td rowspan=\"2\" valign=\"top\" />");
        out.println("\t\t<table border=\"0\">");
        out.println("\t\t\t<tr>");
        out.println("\t\t\t\t<td align=\"left\" id=\"mainButtonBar\"/>");
        out.println("\t\t\t\t<td align=\"right\" id=\"cursorTrack\" />");
        out.println("\t\t\t</tr>");
        out.println("\t\t\t<tr>");
        out.println("\t\t\t\t<td colspan=\"2\" id=\"mainMapPane\" style=\"background-color: white;\" />");
        out.println("\t\t\t</tr>");
        out.println("\t<tr align=\"right\">");
        out.println("\t\t<td colspan=\"2\">");
        out.println("\t\t<table>");
        out.println("\t\t\t<tr>");
        out.println("        <td align=\"left\" id=\"mapScaleText\"/>");
        out.println("\t\t\t\t<td align=\"right\">Powered by <a href=\"http://mapbuilder.sourceforge.net\">Community Map");
        out.println("\t\t\t\tBuilder</a></td>");
        out.println("\t\t\t\t<td><img src=\"../mbdemos/lib/skin/default/images/Icon.gif\" alt=\"\" /></td>");
        out.println("\t\t\t</tr>");
        out.println("\t\t</table>");
        out.println("\t\t</td>");
        out.println("\t</tr>");
        out.println("\t\t</table>");
        out.println("\t\t</td>");
        out.println("\t</tr>");
        out.println("\t<tr>");
        out.println("\t\t<td id=\"legend\" />");
        out.println("\t</tr>");
        out.println("\t<tr>");
        out.println("\t\t<td colspan=\"3\" id=\"featureList\" />");
        out.println("\t</tr>");
        out.println("\t<tr>");
        out.println("\t\t<td colspan=\"3\" id=\"transactionResponse\" />");
        out.println("\t</tr>");
        out.println("\t<tr>");
        out.println("\t\t<td colspan=\"3\">");
        out.println("\t\t<div id=\"eventLog\" />");
        out.println("\t\t</td>");
        out.println("\t</tr>");
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    private void createConfigXML(PrintStream out, String ft_name, String ft_namespace) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        out.println("<MapbuilderConfig version=\"0.2.1\" id=\"referenceTemplate\" xmlns=\"http://mapbuilder.sourceforge.net/mapbuilder\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://mapbuilder.sourceforge.net/mapbuilder ../../mapbuilder/lib/schemas/config.xsd\">");
        out.println("  <!--");
        out.println("    Description: This configuration file determines what components from the");
        out.println("                 Mapbuilder library are to be included in a Main Mapbuilder web");
        out.println("                 page.");
        out.println("    Licence:     GPL as per: http://www.gnu.org/copyleft/gpl.html ");
        out.println("");
        out.println("    $Id: MapPreviewAction.java 4503 2006-06-06 12:59:11Z jdeolive $");
        out.println("  -->");
        out.println("  <!--");
        out.println("    All static images should be relative to this URL.");
        out.println("    This dir is relative the dir of the main html file.");
        out.println("  -->");
        out.println("  <models>");
        out.println("    <Context id=\"mainMap\">");
        out.println("      <defaultModelUrl>" + ft_namespace + "_" + ft_name + ".xml</defaultModelUrl>");
        out.println("      <widgets>");
        out.println("        <MapPane id=\"mainMapWidget\">");
        out.println("          <htmlTagId>mainMapPane</htmlTagId>");
        out.println("          <mapContainerId>mainMapContainer</mapContainerId>");
        out.println("        </MapPane>");
        out.println("        <AoiBoxWZ id=\"aoiBox2\">");
        out.println("          <htmlTagId>mainMapPane</htmlTagId>");
        out.println("          <stylesheet>../mbdemos/lib/widget/GmlRenderer.xsl</stylesheet>");
        out.println("          <lineColor>#FF0000</lineColor>");
        out.println("          <lineWidth>1</lineWidth>");
        out.println("          <crossSize>15</crossSize>");
        out.println("          <mapContainerId>mainMapContainer</mapContainerId>");
        out.println("        </AoiBoxWZ>");
        out.println("        <CursorTrack id=\"cursorTrack\">");
        out.println("          <mouseHandler>mainMap</mouseHandler>");
        out.println("        </CursorTrack>");
        out.println("        <Legend id=\"legend\">");
        out.println("        </Legend>");
        out.println("        <MapScaleText id=\"mapScaleText\">");
        out.println("        </MapScaleText>");
        out.println("      </widgets>");
        out.println("      <tools>");
        out.println("        <AoiMouseHandler id=\"mainAoi\"/>");
        out.println("        <DragPanHandler id=\"mainDragPan\">");
        out.println("          <enabled>false</enabled>");
        out.println("        </DragPanHandler>");
        out.println("        <MouseClickHandler id=\"mainMouseClick\"/>");
        out.println("      </tools>");
        out.println("    </Context>");
        out.println("");
        out.println("    <Context id=\"locator\">");
        out.println("      <defaultModelUrl>" + ft_namespace + "_" + ft_name + ".xml</defaultModelUrl>");
        out.println("      <widgets>");
        out.println("        <MapPane id=\"locatorWidget\">");
        out.println("          <htmlTagId>locatorMap</htmlTagId>");
        out.println("          <targetModel>mainMap</targetModel>");
        out.println("          <mapContainerId>locatorContainer</mapContainerId>");
        out.println("          <fixedWidth>180</fixedWidth>");
        out.println("        </MapPane>");
        out.println("        <AoiBoxWZ id=\"aoiBox2\">");
        out.println("          <htmlTagId>locatorMap</htmlTagId>");
        out.println("          <stylesheet>../mbdemos/lib/widget/GmlRenderer.xsl</stylesheet>");
        out.println("          <lineColor>#FF0000</lineColor>");
        out.println("          <lineWidth>1</lineWidth>");
        out.println("          <crossSize>15</crossSize>");
        out.println("          <mapContainerId>locatorContainer</mapContainerId>");
        out.println("        </AoiBoxWZ>");
        out.println("      </widgets>");
        out.println("      <tools>");
        out.println("        <AoiMouseHandler id=\"locatorAoi\"/>");
        out.println("        <ZoomToAoi id=\"locatorZoomToAoi\">");
        out.println("          <targetModel>mainMap</targetModel>");
        out.println("        </ZoomToAoi>");
        out.println("      </tools>");
        out.println("    </Context>");
        out.println("");
        out.println("    <Transaction id=\"transaction\">");
        out.println("      <widgets>");
        out.println("        <TransactionResponse id=\"transactionResponse\">");
        out.println("        </TransactionResponse>");
        out.println("      </widgets>");
        out.println("    </Transaction>");
        out.println("    <FeatureCollection id=\"featureCollection\">");
        out.println("      <namespace>xmlns:gml='http://www.opengis.net/gml' xmlns:wfs='http://www.opengis.net/wfs' xmlns:topp='http://www.openplans.org/topp'</namespace>");
        out.println("      <widgets>");
        out.println("        <GmlRendererWZ id=\"testGmlRenderer\">");
        out.println("          <htmlTagId>mainMapPane</htmlTagId>");
        out.println("          <targetModel>mainMap</targetModel>");
        out.println("          <mapContainerId>mainMapContainer</mapContainerId>");
        out.println("          <lineColor>#FF0000</lineColor>");
        out.println("          <lineWidth>1</lineWidth>");
        out.println("          <pointDiameter>10</pointDiameter>");
        out.println("        </GmlRendererWZ>");
        out.println("        <FeatureList id=\"featureList\">");
        out.println("        </FeatureList>");
        out.println("      </widgets>");
        out.println("    </FeatureCollection>");
        out.println("  </models>");
        out.println("  <widgets>");
        out.println("    <ZoomIn id=\"zoomIn\">");
        out.println("      <buttonBar>mainButtonBar</buttonBar>");
        out.println("      <targetModel>mainMap</targetModel>");
        out.println("      <mouseHandler>mainAoi</mouseHandler>");
        out.println("      <class>RadioButton</class>");
        out.println("      <selected>true</selected>");
        out.println("      <enabledSrc>/images/ZoomInEnable.gif</enabledSrc>");
        out.println("      <disabledSrc>/images/ZoomInDisable.gif</disabledSrc>");
        out.println("      <tooltip xml:lang=\"en\">click and drag to zoom in</tooltip>");
        out.println("      <tooltip xml:lang=\"fr\">cliquer et faire glisser la souris pour agrandir</tooltip>");
        out.println("    </ZoomIn>");
        out.println("    <ZoomOut id=\"zoomOut\">");
        out.println("      <buttonBar>mainButtonBar</buttonBar>");
        out.println("      <targetModel>mainMap</targetModel>");
        out.println("      <mouseHandler>mainAoi</mouseHandler>");
        out.println("      <class>RadioButton</class>");
        out.println("      <enabledSrc>/images/ZoomOutEnable.gif</enabledSrc>");
        out.println("      <disabledSrc>/images/ZoomOutDisable.gif</disabledSrc>");
        out.println("      <tooltip xml:lang=\"en\">click to zoom out</tooltip>");
        out.println("      <tooltip xml:lang=\"fr\">cliquer pour r???e</tooltip>");
        out.println("    </ZoomOut>");
        out.println("    <DragPan id=\"dragPan\">");
        out.println("      <buttonBar>mainButtonBar</buttonBar>");
        out.println("      <targetModel>mainMap</targetModel>");
        out.println("      <mouseHandler>mainDragPan</mouseHandler>");
        out.println("      <class>RadioButton</class>");
        out.println("      <enabledSrc>/images/PanEnable.gif</enabledSrc>");
        out.println("      <disabledSrc>/images/PanDisable.gif</disabledSrc>");
        out.println("      <tooltip xml:lang=\"en\">click and drag to pan</tooltip>");
        out.println("      <tooltip xml:lang=\"fr\">cliquer et faire glisser la souris pour voir un autre parti de la carte</tooltip>");
        out.println("    </DragPan>");
        out.println("    <Reset id=\"reset\">");
        out.println("      <buttonBar>mainButtonBar</buttonBar>");
        out.println("      <targetModel>mainMap</targetModel>");
        out.println("      <class>Button</class>");
        out.println("      <disabledSrc>/images/ResetExtentDisable.gif</disabledSrc>");
        out.println("      <tooltip xml:lang=\"en\">reset the map to full extent</tooltip>");
        out.println("      <tooltip xml:lang=\"fr\">redonner la carte ses dimensions compl???ts</tooltip>");
        out.println("    </Reset>");
        out.println("  </widgets>");
        out.println("  <skinDir>../mbdemos/lib/skin/default</skinDir>");
        out.println("</MapbuilderConfig>");
    }

    private void createLayersXML(PrintStream out, String ft_name, String ft_namespace, Envelope bbox) throws IOException {
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>");
        out.println("<ViewContext version=\"1.0.0\" id=\"atlas_world\" xmlns=\"http://www.opengis.net/context\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/context http://schemas.opengis.net/context/1.0.0/context.xsd\">");
        out.println("  <General>");
        out.println("    <Window width=\"500\" height=\"285\"/>");
        out.println("    <BoundingBox SRS=\"EPSG:4326\" minx=\"" + bbox.getMinX() + "\" miny=\"" + bbox.getMinY() + "\" maxx=\"" + bbox.getMaxX() + "\" maxy=\"" + bbox.getMaxY() + "\"/>");
        out.println("    <Title>" + ft_namespace + ":" + ft_name + " Map</Title>");
        out.println("    <KeywordList>");
        out.println("      <Keyword>" + ft_namespace + ":" + ft_name + "</Keyword>");
        out.println("    </KeywordList>");
        out.println("    <Abstract></Abstract>");
        out.println("  </General>");
        out.println("  <LayerList>");
        out.println("    <Layer queryable=\"1\" hidden=\"0\">");
        out.println("      <Server service=\"OGC:WMS\" version=\"1.1.1\" title=\"" + ft_namespace + ":" + ft_name + " Preview\">");
        out.println("        <OnlineResource xlink:type=\"simple\" xlink:href=\"../../wms\"/>");
        out.println("      </Server>");
        out.println("      <Name>" + ft_namespace + ":" + ft_name + "</Name>");
        out.println("      <Title>" + ft_namespace + ":" + ft_name + "</Title>");
        out.println("      <SRS>EPSG:4326</SRS>");
        out.println("      <FormatList><Format current=\"1\">image/png</Format></FormatList>");
        out.println("    </Layer>");
        out.println("  </LayerList>");
        out.println("</ViewContext>");
    }
}

