/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class GeoTIFFCoverageResponseDelegate
implements CoverageResponseDelegate {
    private GridCoverage2D sourceCoverage;

    public boolean canProduce(String outputFormat) {
        return outputFormat.equalsIgnoreCase("geotiff");
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.sourceCoverage = coverage;
    }

    public String getContentType(GeoServer gs) {
        return "image/tiff";
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return "attachment;filename=" + this.sourceCoverage.getName() + ".tiff";
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setCompressionQuality(0.75f);
        wp.setTilingMode(2);
        wp.setTiling(256, 256);
        ParameterValueGroup writerParams = format.getWriteParameters();
        writerParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        GridCoverageWriter writer = format.getWriter((Object)output);
        writer.write((GridCoverage)this.sourceCoverage, writerParams.values().toArray(new GeneralParameterValue[1]));
        writer.dispose();
        this.sourceCoverage.dispose();
        this.sourceCoverage = null;
    }
}

