/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wcs.requests.WCSRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WCSCapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$wcs$responses$WCSCapsTransformer == null ? (class$org$vfny$geoserver$wcs$responses$WCSCapsTransformer = WCSCapsTransformer.class$("org.vfny.geoserver.wcs.responses.WCSCapsTransformer")) : class$org$vfny$geoserver$wcs$responses$WCSCapsTransformer).getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs";
    protected static final String WFS_URI = "http://www.opengis.net/wcs";
    protected static final String CUR_VERSION = "1.0.0";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private String baseUrl;
    private ApplicationContext applicationContext;
    protected WCSRequest request;
    static /* synthetic */ Class class$org$vfny$geoserver$wcs$responses$WCSCapsTransformer;
    static /* synthetic */ Class class$org$vfny$geoserver$global$GeoServer;

    public WCSCapsTransformer(String baseUrl, ApplicationContext applicationContext) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        this.baseUrl = baseUrl;
        this.setNamespaceDeclarationEnabled(false);
        this.applicationContext = applicationContext;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCSCapsTranslator(handler, this.applicationContext);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        GeoServer gs = (GeoServer)GeoServerExtensions.extensions((Class)(class$org$vfny$geoserver$global$GeoServer == null ? (class$org$vfny$geoserver$global$GeoServer = WCSCapsTransformer.class$("org.vfny.geoserver.global.GeoServer")) : class$org$vfny$geoserver$global$GeoServer), (ApplicationContext)this.applicationContext).get(0);
        String dtdUrl = RequestUtils.proxifiedBaseURL((String)this.baseUrl, (String)gs.getProxyBaseUrl()) + "schemas/wcs/1.0.0/wcsCapabilities.xsd";
        return transformer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WCSCapsTranslator
    extends TransformerBase.TranslatorSupport {
        private CapabilitiesRequest request;
        private ApplicationContext applicationContext;

        public WCSCapsTranslator(ContentHandler handler, ApplicationContext applicationContext) {
            super(handler, null, null);
            this.applicationContext = applicationContext;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof CapabilitiesRequest)) {
                throw new IllegalArgumentException("Not a CapabilitiesRequest: " + o);
            }
            this.request = (CapabilitiesRequest)o;
            WCS wcs = (WCS)this.request.getServiceRef().getServiceRef();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns", "xmlns", "", "http://www.opengis.net/wcs");
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = "xmlns:" + WCSCapsTransformer.XSI_PREFIX;
            attributes.addAttribute("", prefixDef, prefixDef, "", WCSCapsTransformer.XSI_URI);
            String locationAtt = WCSCapsTransformer.XSI_PREFIX + ":schemaLocation";
            String locationDef = "http://www.opengis.net/wcs " + RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)wcs.getGeoServer().getProxyBaseUrl()) + "schemas/wcs/1.0.0/wcsCapabilities.xsd";
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", wcs.getGeoServer().getUpdateSequence() + "");
            this.start("WCS_Capabilities", attributes);
            this.handleService();
            this.handleCapabilities();
            this.end("WCS_Capabilities");
        }

        private void handleService() {
            WCS wcs = (WCS)this.request.getServiceRef().getServiceRef();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            this.start("Service", attributes);
            this.handleMetadataLink(wcs.getMetadataLink());
            this.element("description", wcs.getAbstract());
            this.element("name", wcs.getName());
            this.element("label", wcs.getTitle());
            this.handleKeywords(wcs.getKeywords());
            this.handleContact(wcs);
            String fees = wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("fees", fees);
            String accessConstraints = wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("accessConstraints", accessConstraints);
            this.end("Service");
        }

        private void handleCapabilities() {
            WCS wcs = (WCS)this.request.getServiceRef().getServiceRef();
            this.start("Capability");
            this.handleRequest(wcs);
            this.handleExceptions(wcs);
            this.handleVendorSpecifics(wcs);
            this.end("Capability");
            this.handleContentMetadata(wcs);
        }

        private void handleRequest(WCS config) {
            this.start("Request");
            this.handleCapability(config, "GetCapabilities");
            this.handleCapability(config, "DescribeCoverage");
            this.handleCapability(config, "GetCoverage");
            this.end("Request");
        }

        private void handleCapability(WCS config, String capabilityName) {
            AttributesImpl attributes = new AttributesImpl();
            this.start(capabilityName);
            this.start("DCPType");
            this.start("HTTP");
            String url = "";
            String baseUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)this.request.getServiceRef().getGeoServer().getProxyBaseUrl());
            baseUrl = ResponseUtils.appendPath((String)baseUrl, (String)"wcs");
            baseUrl = ResponseUtils.appendQueryString((String)baseUrl, (String)"");
            url = this.request.isDispatchedRequest() ? baseUrl : baseUrl + "/" + capabilityName + "?";
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("Get");
            this.start("OnlineResource", attributes);
            this.end("OnlineResource");
            this.end("Get");
            this.end("HTTP");
            this.end("DCPType");
            attributes = new AttributesImpl();
            url = this.request.isDispatchedRequest() ? baseUrl : baseUrl + "/" + capabilityName;
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("DCPType");
            this.start("HTTP");
            this.start("Post");
            this.start("OnlineResource", attributes);
            this.end("OnlineResource");
            this.end("Post");
            this.end("HTTP");
            this.end("DCPType");
            this.end(capabilityName);
        }

        private void handleKeywords(List kwords) {
            this.start("keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("keyword", it.next().toString());
                }
            }
            this.end("keywords");
        }

        private void handleContact(Service config) {
            String tmp = "";
            if (config.getGeoServer().getContactPerson() != null && config.getGeoServer().getContactPerson() != "" || config.getGeoServer().getContactOrganization() != null && config.getGeoServer().getContactOrganization() != "") {
                this.start("responsibleParty");
                tmp = config.getGeoServer().getContactPerson();
                if (tmp != null && tmp != "") {
                    this.element("individualName", tmp);
                    tmp = config.getGeoServer().getContactOrganization();
                    if (tmp != null && tmp != "") {
                        this.element("organisationName", tmp);
                    }
                } else {
                    tmp = config.getGeoServer().getContactOrganization();
                    if (tmp != null && tmp != "") {
                        this.element("organisationName", tmp);
                    }
                }
                if ((tmp = config.getGeoServer().getContactPosition()) != null && tmp != "") {
                    this.element("positionName", tmp);
                }
                this.start("contactInfo");
                this.start("phone");
                tmp = config.getGeoServer().getContactVoice();
                if (tmp != null && tmp != "") {
                    this.element("voice", tmp);
                }
                if ((tmp = config.getGeoServer().getContactFacsimile()) != null && tmp != "") {
                    this.element("facsimile", tmp);
                }
                this.end("phone");
                this.start("address");
                tmp = config.getGeoServer().getAddressType();
                if (tmp != null && tmp != "") {
                    String addr = "";
                    addr = config.getGeoServer().getAddress();
                    if (addr != null && addr != "") {
                        this.element("deliveryPoint", tmp + " " + addr);
                    }
                } else {
                    tmp = config.getGeoServer().getAddress();
                    if (tmp != null && tmp != "") {
                        this.element("deliveryPoint", tmp);
                    }
                }
                tmp = config.getGeoServer().getAddressCity();
                if (tmp != null && tmp != "") {
                    this.element("city", tmp);
                }
                if ((tmp = config.getGeoServer().getAddressState()) != null && tmp != "") {
                    this.element("administrativeArea", tmp);
                }
                if ((tmp = config.getGeoServer().getAddressPostalCode()) != null && tmp != "") {
                    this.element("postalCode", tmp);
                }
                if ((tmp = config.getGeoServer().getAddressCountry()) != null && tmp != "") {
                    this.element("country", tmp);
                }
                if ((tmp = config.getGeoServer().getContactEmail()) != null && tmp != "") {
                    this.element("electronicMailAddress", tmp);
                }
                this.end("address");
                tmp = config.getGeoServer().getOnlineResource();
                if (tmp != null && tmp != "") {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "xlink:href", "xlink:href", "", tmp);
                    this.start("onlineResource", attributes);
                    this.end("onlineResource");
                }
                this.end("contactInfo");
                this.end("responsibleParty");
            }
        }

        private void handleExceptions(WCS config) {
            this.start("Exception");
            String[] formats = config.getExceptionFormats();
            int length = formats.length;
            for (int i = 0; i < length; ++i) {
                this.element("Format", formats[i]);
            }
            this.end("Exception");
        }

        private void handleVendorSpecifics(WCS config) {
        }

        private void handleEnvelope(GeneralEnvelope envelope) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "srsName", "srsName", "", "WGS84(DD)");
            this.start("lonLatEnvelope", attributes);
            this.element("gml:pos", Double.toString(envelope.getLowerCorner().getOrdinate(0)) + " " + envelope.getLowerCorner().getOrdinate(1));
            this.element("gml:pos", Double.toString(envelope.getUpperCorner().getOrdinate(0)) + " " + envelope.getUpperCorner().getOrdinate(1));
            this.end("lonLatEnvelope");
        }

        private void handleMetadataLink(MetaDataLink mdl) {
            if (mdl != null) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
                }
                if (attributes.getLength() > 0) {
                    this.start("metadataLink", attributes);
                    this.end("metadataLink");
                }
            }
        }

        private void handleContentMetadata(WCS config) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            this.start("ContentMetadata", attributes);
            ArrayList coverages = new ArrayList(config.getData().getCoverageInfos().values());
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            Iterator i = coverages.iterator();
            while (i.hasNext()) {
                this.handleCoverageOfferingBrief(config, (CoverageInfo)i.next());
            }
            this.end("ContentMetadata");
        }

        private void handleCoverageOfferingBrief(WCS config, CoverageInfo cv) {
            if (cv.isEnabled()) {
                this.start("CoverageOfferingBrief");
                this.handleMetadataLink(cv.getMetadataLink());
                String tmp = cv.getDescription();
                if (tmp != null && tmp != "") {
                    this.element("description", tmp);
                }
                if ((tmp = cv.getName()) != null && tmp != "") {
                    this.element("name", tmp);
                }
                if ((tmp = cv.getLabel()) != null && tmp != "") {
                    this.element("label", tmp);
                }
                this.handleEnvelope(cv.getWGS84LonLatEnvelope());
                this.handleKeywords(cv.getKeywords());
                this.end("CoverageOfferingBrief");
            }
        }
    }
}

