/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.WCSCapsTransformer;

public class WCSCapabilitiesResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$wcs$responses$WCSCapabilitiesResponse == null ? (class$org$vfny$geoserver$wcs$responses$WCSCapabilitiesResponse = WCSCapabilitiesResponse.class$("org.vfny.geoserver.wcs.responses.WCSCapabilitiesResponse")) : class$org$vfny$geoserver$wcs$responses$WCSCapabilitiesResponse).getPackage().getName());
    private byte[] rawResponse;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wcs$responses$WCSCapabilitiesResponse;

    public WCSCapabilitiesResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        int geoUS;
        if (!(request instanceof CapabilitiesRequest)) {
            throw new IllegalArgumentException("Not a GetCapabilities Request");
        }
        CapabilitiesRequest capreq = (CapabilitiesRequest)request;
        int reqUS = -1;
        if (capreq.getUpdateSequence() != null) {
            try {
                reqUS = Integer.parseInt(capreq.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = request.getServiceRef().getServiceRef().getGeoServer().getUpdateSequence())) {
            throw new WcsException("Client supplied an updateSequence that is greater than the current sever updateSequence", "", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new WcsException("WCS capabilities document is current (updateSequence = " + geoUS + ")", null, "CurrentUpdateSequence");
        }
        WCSCapsTransformer transformer = new WCSCapsTransformer(request.getBaseUrl(), this.applicationContext);
        transformer.setIndentation(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            transformer.transform(request, out);
        }
        catch (TransformerException e) {
            throw new WcsException(e);
        }
        this.rawResponse = out.toByteArray();
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        return gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return null;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        out.write(this.rawResponse);
    }

    public void abort(Service gs) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

