/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.gtopo30.GTopo30Writer;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class GTopo30CoverageResponseDelegate
implements CoverageResponseDelegate {
    private GridCoverage2D sourceCoverage;

    public boolean canProduce(String outputFormat) {
        return outputFormat.compareToIgnoreCase("GTopo30") == 0;
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.sourceCoverage = coverage;
    }

    public String getContentType(GeoServer gs) {
        return "application/x-zip";
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return "attachment;filename=" + this.sourceCoverage.getName() + ".zip";
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        ZipOutputStream outZ = new ZipOutputStream(output);
        output = outZ;
        GTopo30Writer writer = new GTopo30Writer((Object)outZ);
        if (writer == null) {
            throw new ServiceException("Could not create a writer for the format Gtopo30!");
        }
        writer.write((GridCoverage)this.sourceCoverage, null);
        writer.dispose();
        this.sourceCoverage.dispose();
        this.sourceCoverage = null;
    }
}

