/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class AscCoverageResponseDelegate
implements CoverageResponseDelegate {
    private GridCoverage2D sourceCoverage;
    private boolean compressOutput = false;

    public boolean canProduce(String outputFormat) {
        return "ArcGrid".equalsIgnoreCase(outputFormat) || "ArcGrid-GZIP".equalsIgnoreCase(outputFormat);
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.compressOutput = "ArcGrid-GZIP".equalsIgnoreCase(outputFormat);
        this.sourceCoverage = coverage;
    }

    public String getContentType(GeoServer gs) {
        return this.compressOutput ? "application/x-gzip" : "text/plain";
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return this.compressOutput ? "attachment;filename=" + this.sourceCoverage.getName() + ".asc.gz" : null;
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called" + " or has not succeed");
        }
        GZIPOutputStream gzipOut = null;
        if (this.compressOutput) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)output);
            ParameterValueGroup params = writer.getFormat().getWriteParameters();
            writer.write((GridCoverage)this.sourceCoverage, null);
            if (gzipOut != null) {
                gzipOut.finish();
                ((FilterOutputStream)gzipOut).flush();
            }
            writer.dispose();
            this.sourceCoverage.dispose();
            this.sourceCoverage = null;
        }
        catch (Exception e) {
            throw new WcsException("Problems Rendering Image" + e.getMessage(), e);
        }
    }
}

