/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests.readers;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.CoverageHandler;
import org.vfny.geoserver.wcs.requests.CoverageRequest;
import org.vfny.geoserver.wcs.servlets.WCService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class GetCoverageXmlReader
extends XmlRequestReader {
    static /* synthetic */ Class class$org$vfny$geoserver$util$requests$readers$XmlRequestReader;

    public GetCoverageXmlReader(WCService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WcsException {
        InputSource requestSource = new InputSource(reader);
        CoverageHandler contentHandler = new CoverageHandler((WCService)this.getServiceRef());
        try {
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.finest("about to create parser");
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.finest("setting the content handler");
            }
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.finest("content handler = " + contentHandler);
            }
            adapter.setContentHandler(contentHandler);
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.finest("about to parse");
            }
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.finest("calling parse on " + requestSource);
            }
            adapter.parse(requestSource);
            if (XmlRequestReader.LOGGER.isLoggable(Level.FINEST)) {
                XmlRequestReader.LOGGER.fine("just parsed: " + requestSource);
            }
        }
        catch (SAXException e) {
            throw new WcsException(e, "XML getCoverage request SAX parsing error", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = GetCoverageXmlReader.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        catch (IOException e) {
            throw new WcsException(e, "XML get coverage request input error", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = GetCoverageXmlReader.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        catch (ParserConfigurationException e) {
            throw new WcsException(e, "Some sort of issue creating parser", (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader == null ? (class$org$vfny$geoserver$util$requests$readers$XmlRequestReader = GetCoverageXmlReader.class$("org.vfny.geoserver.util.requests.readers.XmlRequestReader")) : class$org$vfny$geoserver$util$requests$readers$XmlRequestReader).getName());
        }
        CoverageRequest r = contentHandler.getRequest(req);
        if (r.getService() != null) {
            String service = r.getService();
            if (!service.trim().toUpperCase().startsWith("WCS")) {
                throw new WcsException("SERVICE parameter is wrong.");
            }
        } else {
            throw new WcsException("SERVICE parameter is mandatory.");
        }
        if (r.getVersion() != null) {
            String version = r.getVersion();
            if (!version.equals("1.0.0")) {
                throw new WcsException("VERSION parameter is wrong.");
            }
        } else {
            throw new WcsException("VERSION parameter is mandatory.");
        }
        if (r.getRequest() != null) {
            String requestType = r.getRequest();
            if (!requestType.equalsIgnoreCase("GetCoverage")) {
                throw new WcsException("REQUEST parameter is wrong.");
            }
        } else {
            throw new WcsException("REQUEST parameter is mandatory.");
        }
        return r;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

