/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.image.WorldImageWriter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class IMGCoverageResponseDelegate
implements CoverageResponseDelegate {
    private GridCoverage2D sourceCoverage;
    private String outputFormat;

    public boolean canProduce(String outputFormat) {
        return outputFormat.equalsIgnoreCase("bmp") || outputFormat.equalsIgnoreCase("gif") || outputFormat.equalsIgnoreCase("tiff") || outputFormat.equalsIgnoreCase("png") || outputFormat.equalsIgnoreCase("jpeg") || outputFormat.equalsIgnoreCase("tif");
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.outputFormat = outputFormat;
        this.sourceCoverage = coverage;
    }

    public String getContentType(GeoServer gs) {
        return "image/" + this.outputFormat.toLowerCase();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return this.outputFormat.equalsIgnoreCase("tiff") || this.outputFormat.equalsIgnoreCase("tif") ? "attachment;filename=" + this.sourceCoverage.getName() + "." + this.outputFormat : null;
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called" + " or has not succeed");
        }
        WorldImageWriter writer = new WorldImageWriter((Object)output);
        Format writerParams = writer.getFormat();
        writerParams.getWriteParameters().parameter("Format").setValue((Object)this.outputFormat.toLowerCase());
        writer.write((GridCoverage)this.sourceCoverage, writerParams.getWriteParameters().values().toArray(new GeneralParameterValue[1]));
        writer.dispose();
        this.sourceCoverage.dispose();
        this.sourceCoverage = null;
    }
}

