/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.InternationalString;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.DescribeRequest;
import org.vfny.geoserver.wcs.requests.WCSRequest;

public class DescribeResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    private static final String CURR_VER = "\"1.0.0\"";
    private static final String WCS_URL = "http://www.opengis.net/wcs";
    private static final String WCS_NAMESPACE = "\n  xmlns=\"" + "http://www.opengis.net/wcs" + "\"";
    private static final String XLINK_URL = "\"http://www.w3.org/1999/xlink\"";
    private static final String XLINK_NAMESPACE = "\n  xmlns:xlink=" + "\"http://www.w3.org/1999/xlink\"";
    private static final String OGC_URL = "\"http://www.opengis.net/ogc\"";
    private static final String OGC_NAMESPACE = "\n  xmlns:ogc=" + "\"http://www.opengis.net/ogc\"";
    private static final String GML_URL = "\"http://www.opengis.net/gml\"";
    private static final String GML_NAMESPACE = "\n  xmlns:gml=" + "\"http://www.opengis.net/gml\"";
    private static final String SCHEMA_URI = "\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final String XSI_NAMESPACE = "\n  xmlns:xsi=" + "\"http://www.w3.org/2001/XMLSchema-instance\"";
    private static final String FOOTER = "\n</CoverageDescription>";
    private DescribeRequest request;
    private String xmlResponse = new String();
    protected final DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
    protected static final CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory((Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, (Object)(class$org$opengis$referencing$crs$CRSAuthorityFactory == null ? (class$org$opengis$referencing$crs$CRSAuthorityFactory = DescribeResponse.class$("org.opengis.referencing.crs.CRSAuthorityFactory")) : class$org$opengis$referencing$crs$CRSAuthorityFactory)));
    protected final MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
    protected static final CoordinateOperationFactory opFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    static /* synthetic */ Class class$org$opengis$referencing$crs$CRSAuthorityFactory;

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws WcsException {
        DescribeRequest wcsRequest;
        WCSRequest request = (WCSRequest)req;
        if (!(request instanceof DescribeRequest)) {
            throw new WcsException("illegal request type, expected DescribeRequest, got " + (Object)((Object)request));
        }
        this.request = wcsRequest = (DescribeRequest)request;
        LOGGER.finer("processing describe request" + (Object)((Object)wcsRequest));
        String outputFormat = wcsRequest.getOutputFormat();
        if (!outputFormat.equalsIgnoreCase("XMLSCHEMA")) {
            throw new WcsException("output format: " + outputFormat + " not " + "supported by geoserver");
        }
        this.xmlResponse = this.generateCoverages(wcsRequest);
        if (!request.getWCS().getGeoServer().isVerbose()) {
            this.xmlResponse = this.xmlResponse.replaceAll(">\n[ \\t\\n]*", ">");
            this.xmlResponse = this.xmlResponse.replaceAll("\n[ \\t\\n]*", " ");
        }
    }

    public String getContentType(GeoServer gs) {
        return gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentDisposition() {
        return null;
    }

    public void writeTo(OutputStream out) throws WcsException {
        try {
            byte[] content = this.xmlResponse.getBytes();
            out.write(content);
        }
        catch (IOException ex) {
            throw new WcsException(ex, "", this.getClass().getName());
        }
    }

    private final String generateCoverages(DescribeRequest wcsRequest) throws WcsException {
        ArrayList requestedTypes = wcsRequest.getCoverages();
        StringBuffer tempResponse = new StringBuffer();
        if (requestedTypes.size() == 0) {
            requestedTypes = new ArrayList(wcsRequest.getWCS().getData().getCoverageInfos().keySet());
        }
        tempResponse.append("<?xml version=\"1.0\" encoding=\"").append(wcsRequest.getGeoServer().getCharSet().displayName()).append("\"?>").append("\n<CoverageDescription version=").append(CURR_VER).append(" ").toString();
        tempResponse.append(WCS_NAMESPACE);
        tempResponse.append(XLINK_NAMESPACE);
        tempResponse.append(OGC_NAMESPACE);
        tempResponse.append(GML_NAMESPACE);
        tempResponse.append(XSI_NAMESPACE);
        tempResponse.append(" xsi:schemaLocation=\"").append(WCS_URL).append(" ").append("http://schemas.opengis.net/wcs/1.0.0/").append("describeCoverage.xsd\">\n\n");
        tempResponse.append(this.generateSpecifiedCoverages(requestedTypes, wcsRequest.getWCS()));
        tempResponse.append(FOOTER);
        return tempResponse.toString();
    }

    private String generateSpecifiedCoverages(List requestedTypes, WCS gs) throws WcsException {
        String tempResponse = new String();
        String curCoverageName = new String();
        int length = requestedTypes.size();
        for (int i = 0; i < length; ++i) {
            curCoverageName = requestedTypes.get(i).toString();
            CoverageInfo meta = gs.getData().getCoverageInfo(curCoverageName);
            if (meta == null) {
                throw new WcsException("Coverage " + curCoverageName + " does " + "not exist on this server");
            }
            tempResponse = tempResponse + DescribeResponse.printElement(meta);
        }
        tempResponse = tempResponse + "\n\n";
        return tempResponse;
    }

    private static String printElement(CoverageInfo cv) {
        String tmp;
        StringBuffer tempResponse = new StringBuffer();
        tempResponse.append("\n <CoverageOffering>");
        if (cv.getMetadataLink() != null) {
            tempResponse.append("\n  <metadataLink about=\"").append(cv.getMetadataLink().getAbout()).append("\" metadataType=\"").append(cv.getMetadataLink().getMetadataType()).append("\"/>");
        }
        if ((tmp = cv.getDescription()) != null && tmp != "") {
            tempResponse.append("\n  <description>").append(tmp).append("</description>");
        }
        if ((tmp = cv.getName()) != null && tmp != "") {
            tempResponse.append("\n  <name>").append(tmp).append("</name>");
        }
        if ((tmp = cv.getLabel()) != null && tmp != "") {
            tempResponse.append("\n  <label>").append(tmp).append("</label>");
        }
        GeneralEnvelope envelope = cv.getWGS84LonLatEnvelope();
        tempResponse.append("\n  <lonLatEnvelope srsName=\"WGS84(DD)\"").append(">");
        tempResponse.append("\n   <gml:pos>").append(envelope.getLowerCorner().getOrdinate(0)).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).append("</gml:pos>");
        tempResponse.append("\n   <gml:pos>").append(envelope.getUpperCorner().getOrdinate(0)).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).append("</gml:pos>");
        tempResponse.append("\n  </lonLatEnvelope>");
        if (cv.getKeywords() != null && cv.getKeywords().size() > 0) {
            tempResponse.append("\n  <keywords>");
            for (int i = 0; i < cv.getKeywords().size(); ++i) {
                tempResponse.append("\n   <keyword>" + cv.getKeywords().get(i) + "</keyword>");
            }
            tempResponse.append("\n  </keywords>");
        }
        GeneralEnvelope cvEnvelope = cv.getEnvelope();
        tempResponse.append("\n  <domainSet>");
        tempResponse.append("\n   <spatialDomain>");
        tempResponse.append("\n    <gml:Envelope").append(cv.getSrsName() != null && cv.getSrsName() != "" ? " srsName=\"" + cv.getSrsName() + "\"" : "").append(">");
        tempResponse.append("\n       <gml:pos>").append(cvEnvelope != null ? Double.toString(cvEnvelope.getLowerCorner().getOrdinate(0)) + " " + cvEnvelope.getLowerCorner().getOrdinate(1) : "").append("</gml:pos>");
        tempResponse.append("\n       <gml:pos>").append(cvEnvelope != null ? Double.toString(cvEnvelope.getUpperCorner().getOrdinate(0)) + " " + cvEnvelope.getUpperCorner().getOrdinate(1) : "").append("</gml:pos>");
        tempResponse.append("\n    </gml:Envelope>");
        GridGeometry g = cv.getGrid();
        InternationalString[] dimNames = cv.getDimensionNames();
        int gridDimension = g.getGridRange().getDimension();
        tempResponse.append("\n    <gml:RectifiedGrid").append(g != null ? " dimension=\"" + gridDimension + "\"" : "").append(">");
        String lowers = "";
        String upers = "";
        for (int r = 0; r < gridDimension; ++r) {
            lowers = lowers + g.getGridRange().getLower(r) + " ";
            upers = upers + g.getGridRange().getUpper(r) + " ";
        }
        tempResponse.append("\n       <gml:limits>");
        tempResponse.append("\n         <gml:GridEnvelope>");
        tempResponse.append("\n         <gml:low>" + (cvEnvelope != null ? lowers : "") + "</gml:low>");
        tempResponse.append("\n         <gml:high>" + (cvEnvelope != null ? upers : "") + "</gml:high>");
        tempResponse.append("\n         </gml:GridEnvelope>");
        tempResponse.append("\n       </gml:limits>");
        if (dimNames != null) {
            for (int dn = 0; dn < dimNames.length; ++dn) {
                tempResponse.append("\n       <gml:axisName>" + dimNames[dn] + "</gml:axisName>");
            }
        }
        tempResponse.append("\n       <gml:origin>");
        tempResponse.append("\n       <gml:pos>" + (cvEnvelope != null ? cvEnvelope.getLowerCorner().getOrdinate(0) + " " + cvEnvelope.getUpperCorner().getOrdinate(1) : "") + "</gml:pos>");
        tempResponse.append("\n       </gml:origin>");
        tempResponse.append("\n       <gml:offsetVector>" + (cvEnvelope != null ? (cvEnvelope.getUpperCorner().getOrdinate(0) - cvEnvelope.getLowerCorner().getOrdinate(0)) / (double)(g.getGridRange().getUpper(0) - g.getGridRange().getLower(0)) : 0.0) + " 0.0</gml:offsetVector>");
        tempResponse.append("\n       <gml:offsetVector>0.0 " + (cvEnvelope != null ? (cvEnvelope.getLowerCorner().getOrdinate(1) - cvEnvelope.getUpperCorner().getOrdinate(1)) / (double)(g.getGridRange().getUpper(1) - g.getGridRange().getLower(1)) : -0.0) + "</gml:offsetVector>");
        tempResponse.append("\n    </gml:RectifiedGrid>");
        tempResponse.append("\n   </spatialDomain>");
        tempResponse.append("\n  </domainSet>");
        CoverageDimension[] dims = cv.getDimensions();
        TreeSet<Double> nodataValues = new TreeSet<Double>();
        try {
            if (dims != null) {
                int numSampleDimensions = dims.length;
                tempResponse.append("\n  <rangeSet>");
                tempResponse.append("\n   <RangeSet>");
                tempResponse.append("\n    <name>" + cv.getName() + "</name>");
                tempResponse.append("\n    <label>" + cv.getLabel() + "</label>");
                tempResponse.append("\n      <axisDescription>");
                tempResponse.append("\n        <AxisDescription>");
                tempResponse.append("\n          <name>Band</name>");
                tempResponse.append("\n          <label>Band</label>");
                tempResponse.append("\n          <values>");
                if (numSampleDimensions == 1) {
                    tempResponse.append("\n            <singleValue>").append("1").append("</singleValue>");
                } else {
                    tempResponse.append("\n            <interval>");
                    tempResponse.append("\n              <min>1</min>");
                    tempResponse.append("\n              <max>" + numSampleDimensions + "</max>");
                    tempResponse.append("\n            </interval>");
                }
                tempResponse.append("\n          </values>");
                tempResponse.append("\n        </AxisDescription>");
                tempResponse.append("\n      </axisDescription>");
                for (int sample = 0; sample < numSampleDimensions; ++sample) {
                    Double[] nodata = dims[sample].getNullValues();
                    if (nodata == null) continue;
                    for (int nd = 0; nd < nodata.length; ++nd) {
                        if (nodataValues.contains(nodata[nd])) continue;
                        nodataValues.add(nodata[nd]);
                    }
                }
                tempResponse.append("\n      <nullValues>");
                if (nodataValues.size() > 0) {
                    if (nodataValues.size() == 1) {
                        tempResponse.append("\n        <singleValue>" + (Double)nodataValues.first() + "</singleValue>");
                    } else {
                        tempResponse.append("\n        <interval>");
                        tempResponse.append("\n          <min>" + (Double)nodataValues.first() + "</min>");
                        tempResponse.append("\n          <max>" + (Double)nodataValues.last() + "</max>");
                        tempResponse.append("\n        <interval>");
                    }
                } else {
                    tempResponse.append("\n        <singleValue>0</singleValue>");
                }
                tempResponse.append("\n      </nullValues>");
                tempResponse.append("\n   </RangeSet>");
                tempResponse.append("\n  </rangeSet>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cv.getRequestCRSs() != null && cv.getRequestCRSs().size() > 0 || cv.getResponseCRSs() != null && cv.getResponseCRSs().size() > 0) {
            tempResponse.append("\n  <supportedCRSs>");
            if (cv.getResponseCRSs() != null && cv.getResponseCRSs().size() > 0 && cv.getRequestCRSs() != null && cv.getRequestCRSs().size() > 0) {
                int i;
                tempResponse.append("\n    <requestResponseCRSs>");
                ArrayList CRSs = new ArrayList();
                for (i = 0; i < cv.getRequestCRSs().size(); ++i) {
                    if (CRSs.contains(cv.getRequestCRSs().get(i))) continue;
                    CRSs.add(cv.getRequestCRSs().get(i));
                }
                for (i = 0; i < cv.getResponseCRSs().size(); ++i) {
                    if (CRSs.contains(cv.getResponseCRSs().get(i))) continue;
                    CRSs.add(cv.getResponseCRSs().get(i));
                }
                for (i = 0; i < CRSs.size(); ++i) {
                    tempResponse.append(CRSs.get(i) + " ");
                }
                tempResponse.append("\n    </requestResponseCRSs>");
            } else {
                int i;
                if (cv.getRequestCRSs() != null && cv.getRequestCRSs().size() > 0) {
                    for (i = 0; i < cv.getRequestCRSs().size(); ++i) {
                        tempResponse.append("\n    <requestCRSs>" + cv.getRequestCRSs().get(i) + "</requestCRSs>");
                    }
                }
                if (cv.getResponseCRSs() != null && cv.getResponseCRSs().size() > 0) {
                    for (i = 0; i < cv.getResponseCRSs().size(); ++i) {
                        tempResponse.append("\n    <responseCRSs>" + cv.getResponseCRSs().get(i) + "</responseCRSs>");
                    }
                }
            }
            tempResponse.append("\n  </supportedCRSs>");
        }
        String nativeFormat = cv.getNativeFormat() != null && cv.getNativeFormat().equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : cv.getNativeFormat();
        String supportedFormat = "";
        if (cv.getSupportedFormats() != null && cv.getSupportedFormats().size() > 0) {
            tempResponse.append("\n  <supportedFormats" + (nativeFormat != null && nativeFormat != "" ? " nativeFormat=\"" + nativeFormat + "\"" : "") + ">");
            for (int i = 0; i < cv.getSupportedFormats().size(); ++i) {
                supportedFormat = (String)cv.getSupportedFormats().get(i);
                supportedFormat = supportedFormat.equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : supportedFormat;
                tempResponse.append("\n    <formats>" + supportedFormat + "</formats>");
            }
            tempResponse.append("\n  </supportedFormats>");
        }
        if (cv.getInterpolationMethods() != null && cv.getInterpolationMethods().size() > 0) {
            tempResponse.append("\n  <supportedInterpolations" + (cv.getDefaultInterpolationMethod() != null && cv.getDefaultInterpolationMethod() != "" ? " default=\"" + cv.getDefaultInterpolationMethod() + "\"" : "") + ">");
            for (int i = 0; i < cv.getInterpolationMethods().size(); ++i) {
                tempResponse.append("\n    <interpolationMethod>" + cv.getInterpolationMethods().get(i) + "</interpolationMethod>");
            }
            tempResponse.append("\n  </supportedInterpolations>");
        }
        tempResponse.append("\n </CoverageOffering>");
        return tempResponse.toString();
    }

    public void abort(Service gs) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

