/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.AscCoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.GTopo30CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.GeoTIFFCoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.coverage.IMGCoverageResponseDelegate;

public class CoverageResponseDelegateFactory {
    private static final List encoders = new LinkedList();

    static {
        encoders.add(new AscCoverageResponseDelegate());
        encoders.add(new IMGCoverageResponseDelegate());
        encoders.add(new GTopo30CoverageResponseDelegate());
        encoders.add(new GeoTIFFCoverageResponseDelegate());
    }

    private CoverageResponseDelegateFactory() {
    }

    public static CoverageResponseDelegate encoderFor(String outputFormat) throws NoSuchElementException {
        CoverageResponseDelegate encoder = null;
        Iterator it = encoders.iterator();
        while (it.hasNext()) {
            encoder = (CoverageResponseDelegate)it.next();
            if (!encoder.canProduce(outputFormat)) continue;
            try {
                if (encoder == null) continue;
                return (CoverageResponseDelegate)encoder.getClass().newInstance();
            }
            catch (IllegalAccessException ex) {
                NoSuchElementException e = new NoSuchElementException("Can't create the encoder " + encoder.getClass().getName());
                e.initCause(ex);
                throw e;
            }
            catch (InstantiationException ex) {
                NoSuchElementException e = new NoSuchElementException("Can't create the encoder " + encoder.getClass().getName());
                e.initCause(ex);
                throw e;
            }
        }
        throw new NoSuchElementException("Can't create the encoder " + encoder.getClass().getName());
    }
}

