/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.wcs.requests.DescribeRequest;
import org.vfny.geoserver.wcs.servlets.WCService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DescribeHandler
extends XMLFilterImpl
implements ContentHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wcs");
    private DescribeRequest request = null;
    private String currentTag = new String();

    public DescribeHandler(WCService service) {
        this.request = new DescribeRequest(service);
    }

    public DescribeRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        LOGGER.finest("found start element: " + localName);
        this.currentTag = localName;
        if (this.currentTag.equals("DescribeCoverage")) {
            int length = atts.getLength();
            int i = 0;
            while (i < length) {
                if (atts.getLocalName(i).equals("outputFormat")) {
                    LOGGER.finest("found outputFormat: " + atts.getValue(i));
                    this.request.setOutputFormat(atts.getValue(i));
                } else if (atts.getLocalName(i).equals("service")) {
                    this.request.setService(atts.getValue(i));
                } else if (atts.getLocalName(i).equals("version")) {
                    this.request.setVersion(atts.getValue(i));
                }
                ++i;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finest("found end element: " + localName);
        this.currentTag = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.currentTag.equals("Coverage")) {
            this.request.addCoverage(s);
            LOGGER.finest("added coverage: " + s);
        }
    }
}

