/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import org.vfny.geoserver.config.ServiceConfig;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.global.dto.WCSDTO;

public class WCSConfig
extends ServiceConfig {
    public static final String CONFIG_KEY = "Config.WCS";
    private boolean gmlPrefixing;

    public WCSConfig() {
    }

    public WCSConfig(WCSDTO w) {
        super(w.getService());
        this.gmlPrefixing = w.isGmlPrefixing();
    }

    public WCSConfig(WCS wcs) {
        this((WCSDTO)wcs.toDTO());
    }

    public void update(WCSDTO dto) {
        if (dto == null) {
            throw new NullPointerException("WCS Data Transfer Object required");
        }
        super.update(dto.getService());
        this.gmlPrefixing = dto.isGmlPrefixing();
    }

    public WCSDTO toDTO() {
        WCSDTO WCSDto = new WCSDTO();
        WCSDto.setService(super.toServDTO());
        WCSDto.setGmlPrefixing(this.gmlPrefixing);
        return WCSDto;
    }

    public boolean isGmlPrefixing() {
        return this.gmlPrefixing;
    }

    public void setGmlPrefixing(boolean b) {
        this.gmlPrefixing = b;
    }
}

