/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class GeoServerResourceLoader
extends DefaultResourceLoader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    Set searchLocations = new TreeSet();
    File baseDirectory;

    public GeoServerResourceLoader() {
    }

    public GeoServerResourceLoader(File baseDirectory) {
        this();
        this.baseDirectory = baseDirectory;
        this.setSearchLocations(Collections.EMPTY_SET);
    }

    public void addSearchLocation(File searchLocation) {
        this.searchLocations.add(searchLocation);
    }

    public void setSearchLocations(Set searchLocations) {
        this.searchLocations = new HashSet(searchLocations);
        if (this.baseDirectory != null) {
            this.searchLocations.add(this.baseDirectory);
        }
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.searchLocations.add(baseDirectory);
    }

    public File find(String location) throws IOException {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        Iterator f = this.searchLocations.iterator();
        while (f.hasNext()) {
            File base = (File)f.next();
            file = new File(base, location);
            try {
                if (!file.exists()) continue;
                return file;
            }
            catch (SecurityException e) {
                LOGGER.warning("Failed attemp to check existance of " + file.getAbsolutePath());
            }
        }
        Resource resource = this.getResource(location);
        if (resource.exists()) {
            return resource.getFile();
        }
        return null;
    }

    public File createDirectory(String location) throws IOException {
        File file = this.find(location);
        if (file != null && !file.isDirectory()) {
            String msg = location + " already exists and is not directory";
            throw new IOException(msg);
        }
        file = new File(location);
        if (file.isAbsolute()) {
            file.mkdir();
            return file;
        }
        if (this.baseDirectory == null) {
            String msg = "No base location set, could not create directory: " + location;
            throw new IOException(msg);
        }
        file = new File(this.baseDirectory, location);
        file.mkdir();
        return file;
    }

    public File createFile(String location) throws IOException {
        File file = this.find(location);
        if (file != null) {
            if (file.isDirectory()) {
                String msg = location + " already exists and is a directory";
                throw new IOException(msg);
            }
            return file;
        }
        file = new File(location);
        if (file.isAbsolute()) {
            file.createNewFile();
            return file;
        }
        if (this.baseDirectory == null) {
            String msg = "No base location set, could not create file: " + location;
            throw new IOException(msg);
        }
        file = new File(this.baseDirectory, location);
        file.createNewFile();
        return file;
    }
}

