/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.geoserver.ows.KvpParser;

public class TimeKvpParser
extends KvpParser {
    private static final String[] PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd'T'HH'Z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    static final long MILLIS_IN_DAY = 86400000L;
    private final DateFormat[] formats = new DateFormat[PATTERNS.length];

    public TimeKvpParser(String key) {
        super(key, List.class);
    }

    public Object parse(String value) throws ParseException {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if ((value = value.trim()).length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        if (value.indexOf(44) >= 0) {
            String[] listDates = value.split(",");
            for (int i = 0; i < listDates.length; ++i) {
                dates.add(this.getDate(listDates[i].trim()));
            }
            return dates;
        }
        String[] period = value.split("/");
        if (period.length == 1) {
            dates.add(this.getDate(value));
            return dates;
        }
        if (period.length == 3) {
            long time;
            Date begin = this.getDate(period[0]);
            Date end = this.getDate(period[1]);
            long millisIncrement = TimeKvpParser.parsePeriod(period[2]);
            long startTime = begin.getTime();
            long endTime = end.getTime();
            int j = 0;
            while ((time = (long)j * millisIncrement + startTime) <= endTime) {
                dates.add(new Date(time));
                ++j;
            }
            return dates;
        }
        throw new ParseException("Invalid time parameter: " + value, 0);
    }

    private Date getDate(String value) throws ParseException {
        for (int i = 0; i < this.formats.length; ++i) {
            if (this.formats[i] == null) {
                this.formats[i] = new SimpleDateFormat(PATTERNS[i], Locale.CANADA);
            }
            ParsePosition pos = new ParsePosition(0);
            Date time = this.formats[i].parse(value, pos);
            if (pos.getIndex() != value.length()) continue;
            return time;
        }
        throw new ParseException("Invalid date: " + value, 0);
    }

    static long parsePeriod(String period) throws ParseException {
        int length = period.length();
        if (length != 0 && Character.toUpperCase(period.charAt(0)) != 'P') {
            throw new ParseException("Invalid period increment given: " + period, 0);
        }
        long millis = 0L;
        boolean time = false;
        int lower = 0;
        while (++lower < length) {
            double factor;
            double value;
            int upper;
            block17: {
                char letter;
                block16: {
                    letter = Character.toUpperCase(period.charAt(lower));
                    if (letter == 'T') {
                        time = true;
                        if (++lower >= length) break;
                    }
                    upper = lower;
                    letter = period.charAt(upper);
                    while (!Character.isLetter(letter) || letter == 'e' || letter == 'E') {
                        if (++upper >= length) {
                            throw new ParseException("Missing symbol in \"" + period + "\".", lower);
                        }
                        letter = period.charAt(upper);
                    }
                    letter = Character.toUpperCase(letter);
                    value = Double.parseDouble(period.substring(lower, upper));
                    if (!time) break block16;
                    switch (letter) {
                        case 'S': {
                            factor = 1000.0;
                            break block17;
                        }
                        case 'M': {
                            factor = 60000.0;
                            break block17;
                        }
                        case 'H': {
                            factor = 3600000.0;
                            break block17;
                        }
                        default: {
                            throw new ParseException("Unknown time symbol: " + letter, upper);
                        }
                    }
                }
                switch (letter) {
                    case 'D': {
                        factor = 8.64E7;
                        break;
                    }
                    case 'W': {
                        factor = 6.048E8;
                        break;
                    }
                    case 'M': {
                        factor = 2.592E9;
                        break;
                    }
                    case 'Y': {
                        factor = 3.15576E10;
                        break;
                    }
                    default: {
                        throw new ParseException("Unknown period symbol: " + letter, upper);
                    }
                }
            }
            millis += Math.round(value * factor);
            lower = upper;
        }
        return millis;
    }
}

