/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public abstract class ServiceExceptionHandler {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.ows");
    List services;

    public ServiceExceptionHandler(List services) {
        this.services = services;
    }

    public ServiceExceptionHandler(Service service) {
        this.services = Collections.singletonList(service);
    }

    public List getServices() {
        return this.services;
    }

    public abstract void handleServiceException(ServiceException var1, Request var2);

    protected void dumpExceptionMessages(ServiceException e, StringBuffer s, boolean xmlEscape) {
        Object ex = e;
        while (true) {
            String message;
            Throwable cause = ex.getCause();
            String lastMessage = message = ex.getMessage();
            if (!"".equals(message)) {
                if (xmlEscape) {
                    s.append(ResponseUtils.encodeXML(message));
                } else {
                    s.append(message);
                }
                if (ex instanceof ServiceException) {
                    Iterator t = ex.getExceptionText().iterator();
                    while (t.hasNext()) {
                        s.append("\n");
                        String msg = (String)t.next();
                        if (lastMessage.equals(msg)) continue;
                        if (xmlEscape) {
                            s.append(ResponseUtils.encodeXML(msg));
                        } else {
                            s.append(t.next());
                        }
                        lastMessage = msg;
                    }
                }
                if (cause != null) {
                    s.append("\n");
                }
            }
            if (ex == cause || cause == null) break;
            ex = cause;
        }
    }
}

