/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.opengis.ows10.ExceptionReportType;
import net.opengis.ows10.ExceptionType;
import net.opengis.ows10.Ows10Factory;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.xml.v1_0.OWS;
import org.geoserver.ows.xml.v1_0.OWSConfiguration;
import org.geoserver.platform.ServiceException;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class DefaultServiceExceptionHandler
extends ServiceExceptionHandler {
    protected boolean verboseExceptions = false;

    public DefaultServiceExceptionHandler() {
        super(Collections.EMPTY_LIST);
    }

    public DefaultServiceExceptionHandler(List services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServiceException(ServiceException exception, Request request) {
        Ows10Factory factory = Ows10Factory.eINSTANCE;
        ExceptionType e = factory.createExceptionType();
        if (exception.getCode() != null) {
            e.setExceptionCode(exception.getCode());
        } else {
            e.setExceptionCode("NoApplicableCode");
        }
        e.setLocator(exception.getLocator());
        StringBuffer sb = new StringBuffer();
        this.dumpExceptionMessages(exception, sb, true);
        e.getExceptionText().add((Object)sb.toString());
        e.getExceptionText().addAll((Collection)exception.getExceptionText());
        if (this.verboseExceptions) {
            e.getExceptionText().add((Object)"Details:");
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(trace));
            e.getExceptionText().add((Object)new String(trace.toByteArray()));
        }
        ExceptionReportType report = factory.createExceptionReportType();
        report.setVersion("1.0.0");
        report.getException().add((Object)e);
        request.getHttpResponse().setContentType("application/xml");
        OWSConfiguration configuration = new OWSConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration, configuration.schema());
        encoder.setIndenting(true);
        encoder.setIndentSize(2);
        encoder.setLineWidth(60);
        encoder.setSchemaLocation("http://www.opengis.net/ows", RequestUtils.schemaBaseURL(request.getHttpRequest()) + "ows/1.0.0/owsExceptionReport.xsd");
        try {
            encoder.encode((Object)report, OWS.EXCEPTIONREPORT, (OutputStream)request.getHttpResponse().getOutputStream());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
        finally {
            try {
                request.getHttpResponse().getOutputStream().flush();
            }
            catch (IOException ioe) {}
        }
    }
}

