/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public abstract class ServiceExceptionHandler {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.ows");
    List services;

    public ServiceExceptionHandler(List services) {
        this.services = services;
    }

    public ServiceExceptionHandler(Service service) {
        this.services = Collections.singletonList(service);
    }

    public List getServices() {
        return this.services;
    }

    public abstract void handleServiceException(ServiceException var1, Service var2, HttpServletRequest var3, HttpServletResponse var4);

    protected void dumpExceptionMessages(ServiceException e, StringBuffer s) {
        Object ex = e;
        while (true) {
            Throwable cause = ex.getCause();
            String message = ex.getMessage();
            if (!"".equals(message)) {
                s.append(ResponseUtils.encodeXML(message));
                if (ex instanceof ServiceException) {
                    Iterator t = ex.getExceptionText().iterator();
                    while (t.hasNext()) {
                        s.append("\n").append(t.next());
                    }
                }
                if (cause != null) {
                    s.append("\n");
                }
            }
            if (ex == cause || cause == null) break;
            ex = cause;
        }
    }
}

