/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KvpUtils {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");
    public static final String KEYWORD_DELIMITER = "&";
    public static final String VALUE_DELIMITER = "=";
    public static final String OUTER_DELIMETER = "()";
    public static final String INNER_DELIMETER = ",";

    public static List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>();
        List unparsed = KvpUtils.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                LOGGER.finer("looking at featureId" + fid);
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                LOGGER.finer("adding typename: " + typeName + " from fid");
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    public static List readFlat(String rawList) {
        return KvpUtils.readFlat(rawList, INNER_DELIMETER);
    }

    public static List readFlat(String rawList, String delimiter) {
        ArrayList<String> kvpList = null;
        if (rawList == null || "".equals(rawList)) {
            return Collections.EMPTY_LIST;
        }
        if (rawList.equals("*")) {
            return Collections.EMPTY_LIST;
        }
        if (delimiter.length() == 1) {
            int index = -1;
            kvpList = new ArrayList<String>(10);
            rawList = rawList + delimiter;
            while ((index = rawList.indexOf(delimiter)) > -1) {
                String token = rawList.substring(0, index);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("adding simple element " + token);
                }
                kvpList.add(token);
                rawList = rawList.substring(++index);
            }
        } else {
            StringTokenizer kvps = new StringTokenizer(rawList, delimiter);
            kvpList = new ArrayList(kvps.countTokens());
            while (kvps.hasMoreTokens()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("adding simple element");
                }
                kvpList.add(kvps.nextToken());
            }
        }
        return kvpList;
    }

    public static List readNested(String rawList) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("reading nested: " + rawList);
        }
        ArrayList<List> kvpList = new ArrayList<List>(10);
        if (rawList == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found implicit all requested");
            }
            return kvpList;
        }
        if (rawList.equals("*")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found explicit all requested");
            }
            return kvpList;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found explicit requested");
        }
        if (rawList.startsWith("(")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading complex list");
            }
            List outerList = KvpUtils.readFlat(rawList, OUTER_DELIMETER);
            ListIterator i = outerList.listIterator();
            while (i.hasNext()) {
                kvpList.add(KvpUtils.readFlat((String)i.next(), INNER_DELIMETER));
            }
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading simple list");
            }
            kvpList.add(KvpUtils.readFlat(rawList, INNER_DELIMETER));
        }
        return kvpList;
    }

    public static Map parseKvpSet(String qString) {
        String cleanRequest = KvpUtils.clean(qString);
        LOGGER.fine("clean request is " + cleanRequest);
        HashMap<String, String> kvps = new HashMap<String, String>();
        StringTokenizer requestKeywords = new StringTokenizer(cleanRequest.trim(), KEYWORD_DELIMITER);
        while (requestKeywords.hasMoreTokens()) {
            String kvpPair = requestKeywords.nextToken();
            if (kvpPair.toUpperCase().startsWith("FILTER")) {
                String filterVal = kvpPair.substring(7);
                LOGGER.finest("putting filter value " + filterVal);
                kvps.put("FILTER", filterVal);
                continue;
            }
            StringTokenizer requestValues = new StringTokenizer(kvpPair, VALUE_DELIMITER);
            if (!requestValues.hasMoreTokens()) continue;
            String key = requestValues.nextToken().toUpperCase();
            if (!requestValues.hasMoreTokens()) continue;
            String value = requestValues.nextToken();
            LOGGER.finest("putting kvp pair: " + key + ": " + value);
            kvps.put(key, value);
        }
        LOGGER.fine("returning parsed " + kvps);
        return kvps;
    }

    public static String clean(String raw) {
        LOGGER.finest("raw request: " + raw);
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.finer("Bad encoding for decoder " + e);
            }
        } else {
            return "";
        }
        LOGGER.finest("cleaned request: " + raw);
        return clean;
    }
}

