/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util.requests.readers;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.xerces.parsers.SAXParser;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.util.requests.DispatcherHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DispatcherXmlReader {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers");
    private DispatcherHandler currentRequest;

    public void read(Reader reader, HttpServletRequest req) throws ServiceException {
        InputSource requestSource = new InputSource(reader);
        SAXParser parser = new SAXParser();
        this.currentRequest = new DispatcherHandler();
        try {
            parser.setContentHandler(this.currentRequest);
            parser.parse(requestSource);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getCause() == null) {
                e.initCause(e.getException());
            }
            throw new ServiceException((Throwable)e, "XML request parsing error", DispatcherXmlReader.class.getName());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "XML request input error", DispatcherXmlReader.class.getName());
        }
    }

    public String getService() {
        return this.currentRequest.getService();
    }

    public String getRequest() {
        LOGGER.info("getting request type from " + this.currentRequest);
        return this.currentRequest.getRequest();
    }
}

