/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.util.HashSet;
import java.util.Set;
import org.vfny.geoserver.global.xml.NameSpaceElement;

public abstract class NameSpaceTranslator {
    private String prefix;

    public NameSpaceTranslator(String prefix) {
        this.prefix = prefix;
    }

    public Set getAssociatedTypes(Class type) {
        if (type == null) {
            return null;
        }
        HashSet<NameSpaceElement> r = new HashSet<NameSpaceElement>();
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            Class cls;
            if (nse == null || (cls = nse.getJavaClass()) == null || !cls.isAssignableFrom(type) || cls.equals(Object.class)) continue;
            r.add(nse);
        }
        return r;
    }

    public Set getAssociatedTypes(String type) {
        if (type == null) {
            return null;
        }
        HashSet<NameSpaceElement> r = new HashSet<NameSpaceElement>();
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            if (nse == null) continue;
            String name = nse.getTypeRefName();
            if (name != null && name.indexOf(type) != -1) {
                r.add(nse);
            }
            if ((name = nse.getTypeDefName()) == null || name.indexOf(type) == -1) continue;
            r.add(nse);
        }
        return r;
    }

    public boolean isValidDefinition(String definition) {
        if (definition == null || definition == "") {
            return false;
        }
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            if (nse == null) continue;
            String def = nse.getTypeDefName();
            if (def != null && def.equals(definition)) {
                return true;
            }
            def = nse.getQualifiedTypeDefName();
            if (def == null || !def.equals(definition)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidTypeRef(String type) {
        if (type == null || type == "") {
            return false;
        }
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            if (nse == null) continue;
            String tp = nse.getTypeRefName();
            if (tp != null && tp.equals(type)) {
                return true;
            }
            tp = nse.getQualifiedTypeRefName();
            if (tp == null || !tp.equals(type)) continue;
            return true;
        }
        return false;
    }

    public abstract Set getElements();

    public Set getElements(Class type) {
        if (type == null) {
            return null;
        }
        HashSet<NameSpaceElement> r = new HashSet<NameSpaceElement>();
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            if (nse == null || !type.equals(nse.getJavaClass())) continue;
            r.add(nse);
        }
        return r;
    }

    public NameSpaceElement getElement(String name) {
        if (name == null) {
            return null;
        }
        Set elems = this.getElements();
        for (NameSpaceElement nse : elems) {
            if (nse == null) continue;
            if (name.equals(nse.getTypeRefName())) {
                return nse;
            }
            if (name.equals(nse.getTypeDefName())) {
                return nse;
            }
            if (name.equals(nse.getQualifiedTypeRefName())) {
                return nse;
            }
            if (!name.equals(nse.getQualifiedTypeDefName())) continue;
            return nse;
        }
        return null;
    }

    public NameSpaceElement getDefaultElement(Class type) {
        Set posibilities = this.getElements(type);
        if (posibilities.size() == 0) {
            return null;
        }
        for (NameSpaceElement nse : posibilities) {
            if (nse == null || !nse.isDefault()) continue;
            return nse;
        }
        return null;
    }

    public NameSpaceElement getElement(Class type, String name) {
        if (type == null) {
            return null;
        }
        Set posibilities = this.getElements(type);
        if (posibilities.size() == 0) {
            return null;
        }
        if (posibilities.size() == 1) {
            return (NameSpaceElement)posibilities.toArray()[0];
        }
        if (name == null) {
            return (NameSpaceElement)posibilities.toArray()[0];
        }
        for (NameSpaceElement nse : posibilities) {
            if (nse == null) continue;
            if (name.equals(nse.getTypeRefName())) {
                return nse;
            }
            if (name.equals(nse.getTypeDefName())) {
                return nse;
            }
            if (name.equals(nse.getQualifiedTypeRefName())) {
                return nse;
            }
            if (name.equals(nse.getQualifiedTypeDefName())) {
                return nse;
            }
            if (!nse.isDefault()) continue;
            return nse;
        }
        return (NameSpaceElement)posibilities.toArray()[0];
    }

    public abstract String getNameSpace();

    public final String getPrefix() {
        return this.prefix;
    }
}

